/*								-*- C++ -*-
 * $Id: DLG_base.cpp,v 1.3 1997-01-30 09:55:44+01 mho Exp $
 *
 * Purpose: dialog function box (used for common dialogs)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "DLG_base.h"
#endif

#define  Uses_wxButton
#define  Uses_wxDialogBase
#define  Uses_wxMessage
#include "wx.h"

//-----------------------------------------------------------------------------
// implemetation of wxDialogBase
//-----------------------------------------------------------------------------

IMPLEMENT_CLASS(wxDialogBase, wxDialogBox)

wxDialogBase::wxDialogBase(const char *message, const wxBitmap *bitmap,
			   const char *caption, int style,
			   wxWindow *parent, int _x, int _y)
{
    h_space  = 5;
    v_space  = 5;
    h_margin = 10;
    v_margin = 5;

    yes = no = ok = cancel = NULL;
    dlg_style = style;
    x = _x; y = _y;
    msg = bmp = NULL; buttons = NULL;
    title = caption;

    // busy cursor
    wxBeginBusyCursor();
    // find a parent, that is a frame => centre works better and it is more
    wxWindow *p = parent;
    for (/*wxWindow *p = parent*/; p; p = p->GetParent())
	if (p->IsKindOf(CLASSINFO(wxFrame)))
	    break;
    // create dialogbox (p is now NULL or a frame)
    Create((wxFrame*)p, caption, TRUE, -1, -1, -1, -1,
	   wxDEFAULT_DIALOG_STYLE, "dialogBase");
    // create message (with button font)
    if (dlg_style & wxICON_EXCLAMATION )  bitmap = wxDLG_WARNING_ICON;
    if (dlg_style & wxICON_HAND )         bitmap = wxDLG_NOENTER_ICON;
    if (dlg_style & wxICON_QUESTION )     bitmap = wxDLG_QUESTION_ICON;
    if (dlg_style & wxICON_INFORMATION )  bitmap = wxDLG_INFO_ICON;
    if (bitmap)
	bmp = wxNEW wxMessage(this, (wxBitmap*)bitmap, -1, -1);
    if (message) {
	msg = wxNEW wxMessage(this, (*message) ? message : "\"\"",
			      -1, -1, wxUSE_BUTTON_FONT|wxNO_BORDER);
	// adjust alignment of message
	if (dlg_style & wxCENTRE)
	    msg->SetAlignment(wxALIGN_CENTRE);
    }
    if (bmp || msg)
	NewLine(2 * v_space);
}

int wxDialogBase::GetInput(void)
{
    if (GetChildren()->Number() > (msg ? 1 : 0)) // more than the message
	NewLine(2 * v_space);

    // create buttons (subpanel has no margins)
    buttons = wxNEW wxPanel(this, -1, -1, -1, -1, wxNO_DC, "button_panel");
    buttons->SetHorizontalMargin(0);
    buttons->SetVerticalMargin(0);

    if (dlg_style & wxSAVE_DISCARD) {
	yes = wxNEW wxButton(buttons, NULL, "Save", -1, -1, 70);
	no  = wxNEW wxButton(buttons, NULL, "Discard", -1, -1, 70);
	yes->SetDefault();
    } else if (dlg_style & wxYES_NO) {
	yes = wxNEW wxButton(buttons, NULL, "Yes", -1, -1, 70);
	no  = wxNEW wxButton(buttons, NULL, "No", -1, -1, 70);
	yes->SetDefault();
    } else if (dlg_style & wxOK) {
	ok = wxNEW wxButton(buttons, NULL, "Ok", -1, -1, 70);
	ok->SetDefault();
    }
    if (dlg_style & wxCANCEL) {
	cancel = wxNEW wxButton(buttons, NULL, "Cancel", -1, -1, 70);
    }
    buttons->Fit();

    // resize dialog box and position message and buttons properly
    Fit();
    // is there enough space for the caption?
    int w, h; float tw, th;
    GetSize(&w, &h);
    GetTextExtent(title, &tw, &th, NULL, NULL, &label_font);
    if (tw + 70 > float(w))
	SetSize(w = int(tw + 70), -1);
    // centre buttons
    buttons->Centre(wxHORIZONTAL);
    //###########MSEDITSTART
    // center contents in Dialogbox
    if (dlg_style & wxCENTRE)
      {
	wxList *tmp=GetChildren();
	for(int i=0;i<tmp->Number();i++) 
	  {
	    wxObject * obj=(tmp->Nth(i))->Data();
	    if ((obj!=bmp)&&(obj!=msg)&&(obj!=buttons))
	      {
		((wxWindow*)obj)->Centre(wxHORIZONTAL);
	      }
	  }
      }
    //###########MSEDITEND
    // make dialog not-resizable
    SetMinSize(w, h); SetMaxSize(w, h);
    // position dialogbox on screen
    Move(x, y);
    if (x < 0)
	Centre(wxHORIZONTAL);
    if (y < 0)
	Centre(wxVERTICAL);

    // un-busy cursor
    wxEndBusyCursor();
    // show modal dialog box and wait for input
    Show(TRUE);

    return pressed_button;
}

Bool wxDialogBase::OnCharHook(wxKeyEvent &event)
{
    if (event.KeyCode() == WXK_ESCAPE) {
	pressed_button = wxCANCEL;
	Show(FALSE);
	return TRUE;
    }
    if (event.KeyCode() == WXK_RETURN && event.eventObject != cancel) {
	pressed_button = wxOK;
	Show(FALSE);
	return TRUE;
    }
    // maybe, that other keys are handled (e.g. F1 by wxApp for help)
    return wxDialogBox::OnCharHook(event);
}

Bool wxDialogBase::OnClose(void)
{
    pressed_button = wxCANCEL;
    Show(FALSE);

    // forbid destruction of dialog box, Show(FALSE) exits modal event loop
    return FALSE;
}

void wxDialogBase::OnCommand(wxWindow &win, wxCommandEvent &event)
{
    switch (event.eventType) {
    case wxEVENT_TYPE_BUTTON_COMMAND:
	if (&win == yes)
	    pressed_button = (dlg_style & wxYES_NO) ? wxYES : wxSAVE;
	else if (&win == no)
	    pressed_button = (dlg_style & wxYES_NO) ? wxNO : wxDISCARD;
	else if (&win == ok)
	    pressed_button = wxOK;
	else
	    pressed_button = wxCANCEL;
	break;
    default:
	return;
    }
    Show(FALSE);
}

void wxDialogBase::OnPaint(void)
{
    if (buttons) {
	int x, y, width, height;
	GetSize(&width, &height);
	buttons->GetPosition(&x, &y);
	DrawStaticLine(0, y - 1, width);
    }
    wxDialogBox::OnPaint();
}

void wxDialogBase::OnSize(int width, int height)
{
    if (!buttons)
	return;

    GetClientSize(&width, &height);

    int wBmp=0, hBmp=0, wMsg=0, hMsg=0, xBmp=0, yBmp=0, xMsg=0, yMsg=0;

    // get sizes
    if (bmp) bmp->GetSize(&wBmp, &hBmp);
    if (msg) msg->GetSize(&wMsg, &hMsg);

    // vertical position
    if (bmp && msg) {
	if (hBmp < hMsg)  yBmp = (hMsg-hBmp)/2;
	else              yMsg = (hBmp-hMsg)/2;
    }
    if (bmp)
	xMsg = wBmp + h_space;
    wMsg = width - xMsg;

    // set positions and sizes
    if (bmp)     bmp->Move(xBmp, yBmp);
    if (msg)     msg->SetSize(xMsg, yMsg, wMsg, hMsg);
    if (buttons) buttons->Centre(wxHORIZONTAL);
}
