/*								-*- C++ -*-
 * $Id: WIN_windowupdate.cpp,v 1.1 1996-09-25 11:32:39+02 mho Exp $
 *
 * Purpose: handle expose parts (included as is from Window.cpp)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1996, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1996, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

//-----------------------------------------------------------------------------
// ask, if a part of the wxWindow is exposed
//-----------------------------------------------------------------------------

int wxWindow::IsExposed(float x, float y)
{
    if (dc)
	return dc->IsExposed(x, y);

    if (!X->expose_region)
	return wxEXPOSED_FULL;
    if (XPointInRegion(X->expose_region, LogicalToDeviceX(x), LogicalToDeviceY(y)))
	return wxEXPOSED_FULL;
    return wxEXPOSED_NOT;
}

int wxWindow::IsExposed(float x, float y, float w, float h)
{
    if (dc)
	return dc->IsExposed(x, y, w, h);

    if (!X->expose_region)
	return wxEXPOSED_FULL;

    int          ix = LogicalToDeviceX(x);
    int          iy = LogicalToDeviceY(y);
    unsigned int iw = LogicalToDeviceXRel(w);
    unsigned int ih = LogicalToDeviceYRel(h);

    switch (XRectInRegion(X->expose_region, ix, iy, iw, ih)) {
    case RectangleIn:   return wxEXPOSED_FULL;
    case RectanglePart: return wxEXPOSED_PART;
    }
    return wxEXPOSED_NOT;
}
//-----------------------------------------------------------------------------
// wxUpdateIterator should allow iteration through damaged rectangles.
// This class is only provided for compatibility with the standard draft.
// It is recommended to use wxDC::IsExposed().
//-----------------------------------------------------------------------------

IMPLEMENT_ABSTRACT_CLASS(wxUpdateIterator, wxObject)

wxUpdateIterator::wxUpdateIterator(wxWindow* _win)
{
    wxASSERT((win!=0), "wxUpdateIterator initialize without wxWindow");

    win = _win;
    c   = 0;

    if (win->X->expose_region) { // expose_region is set during an expose event
	XRectangle xrect;

	win->GetClientPosition(&cx, &cy);
	XClipBox(win->X->expose_region, &xrect);

	cx += xrect.x;		// adjustion necessary, because
	cy += xrect.y;		// scrolled window widget class moves client
	cw  = xrect.width;
	ch  = xrect.height;
    } else {
	cx = cy = 0;			// I don't know anything
	win->GetClientSize(&cw, &ch);	// => take whole canvas
    }
}

wxUpdateIterator::~wxUpdateIterator(void)
{
}

wxUpdateIterator::operator int (void)
{
    return (c == 0); // there is only ONE ENTIRE rectangle
}

wxUpdateIterator* wxUpdateIterator::operator ++(int)
{
    ++c;
    return this;
}

void wxUpdateIterator::GetRect(wxRectangle *rect)
{
    rect->x      = cx;
    rect->y      = cy;
    rect->width  = cw;
    rect->height = ch;
}
