/*								-*- C++ -*-
 * $Id: IPC_help.h,v 1.1 1996-09-25 11:06:26+02 mho Exp $
 *
 * Purpose: connection to wxHelp server
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Help_h
#define Help_h

#ifdef __GNUG__
#pragma interface
#endif

class wxHelpInstance;

class wxHelpConnection : public wxConnection {
DECLARE_DYNAMIC_CLASS(wxHelpConnection)
public:
    wxHelpConnection(wxHelpInstance *instance);
    Bool OnDisconnect(void);
private:
    wxHelpInstance *helpInstance;
};

class wxHelpInstance : public wxClient {
DECLARE_DYNAMIC_CLASS(wxHelpInstance)
public:
    wxHelpInstance(Bool native = FALSE);
    ~wxHelpInstance(void);

    Bool DisplayBlock(long blockNo);
    Bool DisplayContents(void);
    Bool DisplaySection(int sectionNo);
    Bool Initialize(char *file, int server = -1);
    Bool KeywordSearch(char *k);
    Bool LoadFile(char *file = NULL);
    Bool Quit(void);

    virtual void OnQuit(void)
	{}

    Bool Run(void);
    inline wxConnection *OnMakeConnection(void)
	{ return wxNEW wxHelpConnection(this); }
private:
    friend class wxHelpConnection;

    char *helpFile;
    int  helpServer;
    char *helpHost;
    Bool helpRunning;
    Bool useNative;
    wxHelpConnection *helpConnection;
};

#endif // Help_h
