/*************************************************
*     Exim - an Internet mail transport agent    *
*************************************************/

/* Copyright (c) University of Cambridge 1995 - 1998 */
/* See the file NOTICE for conditions of use and distribution. */

#include "../exim.h"
#include "testdb.h"

/* Compile these functions only if LOOKUP_TESTDB is defined. However, some
compilers don't like compiling empty modules, so keep them happy with a
dummy when skipping the rest. */

#ifndef LOOKUP_TESTDB
static void dummy(void) { dummy(); }
#else


/* These are not real lookup functions; they are just a way of testing the
rest of Exim by providing an easy way of specifying particular yields from
the find function. */


/*************************************************
*              Open entry point                  *
*************************************************/

/* See local README for interface description. */

void *
testdb_open(char *filename, char **errmsg)
{
return (void *)(1);    /* Just return something non-null */
}



/*************************************************
*               Find entry point                 *
*************************************************/

/* See local README for interface description. */

int
testdb_find(void *handle, char *filename, char *query, int length,
  char **result, char **errmsg)
{
if (strcmp(query, "fail") == 0)
  {
  *errmsg = "testdb lookup forced FAIL";
  return FAIL;
  }
if (strcmp(query, "defer") == 0)
  {
  *errmsg = "testdb lookup forced DEFER";
  return DEFER;
  }
*result = string_copy(query);
return OK;
}

#endif  /* LOOKUP_TESTDB */

/* End of lookups/testdb.c */
