# $Id: bar.tcl,v 1.2 1998/10/19 23:26:13 cthulhu Exp $

# Bar

proc createBarGraph {cnt} {

    source "[xxl_library]/globalvars.tcl"
    global yScale xScale
    
    set cols [expr [lindex $graphRange 2]-[lindex $graphRange 0]+1]
    set rows [expr [lindex $graphRange 3]-[lindex $graphRange 1]+1]
    
    set canvas [canvasFromSheet $activeSheet]

    set ini [expr (($cols==1)? 0:1)]
    
    $canvas create rect $graphX $graphY \
	[expr $graphX+$graphWidth] [expr $graphY+$graphHeight] X \
	$graphCol $graphRow $graphCol $graphRow -fill white \
	-tag graph_$cnt
    
    #
    # Width of each
    #
    set gh [expr $graphHeight-2*5*$graphMargin]
    set gw [expr $graphWidth-2*5*$graphMargin]
    set gm [expr 5*$graphMargin]    
    
    
    #
    # Find max and min  - procura nos valores das celulas seleccionadas
    #
    set max -1.0e+20
    set min 1.0e+20
    for {set j $ini} {$j < $cols} {incr j} {
        for {set i 0} {$i < $rows} {incr i} {
            set x [graphData $activeSheet $cnt $j $i 1]
	    if { $x == ""} {set x 0}
            if {$max < $x} {set max $x} 
            if {$min > $x } {set min $x}
        }
    }

    if {$x==0} {set x 1} 
    if {$gw==0} {set gw 1}
    if {$gh==0} {set gh 1}
    if {$max==0} {set max 1}
    
    set xScale $gw
    set yScale $gh
    
    if {$max > 0 && $min < 0} {
        set yDim [expr 1.0*$max-$min] 
        set zero [expr 1.0*(-$min) / ($max - $min)]
    } else {
        if {$max > 0} {
            set zero 0.0
            set yDim $max
        } else {
            set zero 1.0
            set yDim [expr -$min]
        }
    }
    
    #
    # Draw axes
    # 


    $canvas create rect [expr $gm+$graphX] [expr $gm+$graphY] [expr $gm+$gw+$graphX] \
	[expr $gm+$gh+$graphY] X $graphCol $graphRow $graphCol $graphRow \
	-fill gray80 -outline gray80 -tag graph_$cnt
    
    #draw the axes
    
    drawRectangle $canvas black 0 $zero 1.0 $zero $cnt 5
    
    for {set i 0} {$i <= 10} {incr i} {
        set label [expr $i/10.0*$max]
	
	if {$max>999} {
	    set label [format "%1.0g" $label]
	}

	$canvas create text  $graphCol $graphRow X [expr $graphX-$gm/5] \
	    [expr $graphY+$gm+(10-$i)/10.0*$gh-5] \
	    -text $label -tag graph_$cnt
        $canvas create line \
	    [expr $graphX+$gm-4] [expr $graphY+$gm+$gh-$label/$max*$gh] \
	    [expr $graphX+$gm] [expr $graphY+$gm+$gh-$label/$max*$gh]  X \
	    $graphCol $graphRow $graphCol $graphRow -tag graph_$cnt 
    }

    #desenha o eixo das abcissas

    if {$ini!=0} {
	
	for {set i 0} {$i < $rows} {incr i} {
	    set label [string range [graphData $activeSheet $cnt 0 $i] 0 4]
	    
	    $canvas create text  $graphCol $graphRow X [expr $graphX+$gm+$gw*$i/$rows] \
		[expr $graphY+$gm+$gh-2] \
		-text $label -anchor w -tag graph_$cnt
	}
    }
    
    #
    #
    # Draw legends
    #

    if {$ini!=0} {
    
	$canvas create rect [expr $graphX+$graphWidth] [expr $gm+$graphY] \
	    [expr $graphX+$graphWidth+90] [expr $gm+30*$cols+$graphY] X \
	    $graphCol $graphRow $graphCol $graphRow -fill white \
	    -tag graph_$cnt
	
	$canvas create text $graphCol [expr $graphRow] X \
	    [expr 2*$gm+$gw+$graphX] [expr $gm+$graphY+5] \
	    -text "Legend:" -anchor w -tag graph_$cnt
	
	for {set i 1} {$i < $cols} {incr i} {
	    $canvas create rect \
		[expr 2*$gm+$gw+3+$graphX] [expr $gm+30*$i+$graphY] \
		[expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+15+$graphY] \
		X  $graphCol $graphRow $graphCol $graphRow -fill [colorIndex $i]\
		-tag graph_$cnt
	    
	    $canvas create text $graphCol [expr $graphRow-1] X \
		[expr 5*$gm/2+$gw+$graphX] [expr $gm+30*$i+18+$graphY] \
		-text "Col $i" -anchor w -tag graph_$cnt    
	}
    }
    #
    # Draw rectangles
    #
    
    if {$cols == 2} {
        set rw [expr 1.0/($cols-1)/$rows]
    } elseif {$cols>2} {
        set rw [expr 0.9/($cols-1)/$rows]
    } else {
        set rw [expr 1.0/1.0/$rows]
    }
    
    for {set j $ini} {$j < $cols} {incr j} {
        for {set i 0} {$i < $rows} {incr i} {
            set y [graphData $activeSheet $cnt $j $i 1]
	    if {$y==""} {set y 0}
            drawRectangle $canvas [colorIndex $j] \
		[expr 1.0*$i/$rows+$rw*([expr (($j==0)? 1:$j)]-1)] $zero \
		[expr 1.0*$i/$rows+$rw*([expr (($j==0)? 1:$j)])] [expr $zero+1.0*$y/$yDim] \
		$cnt 5
        }
    }
}

# $Log: bar.tcl,v $
# Revision 1.2  1998/10/19 23:26:13  cthulhu
# Fixed bug when displaying graphs with total col/row values adding up to zero.
#
# Revision 1.1  1998/08/17 20:11:22  cthulhu
# Initial revision
#
