/* $Id: cutils.c,v 1.1 1998/08/17 20:23:26 cthulhu Exp $ */

#include "defines.hh"
#include "canvas.h"
#include "utils.h"

int *global_col_origin;
int *global_row_origin;

int x_coord(int col,Canvas *c) {
  if (col < 0) col = 0;
  /*  if (c->row_origin[1] != DEFCELLHEIGHT) 
    fprintf(stderr,"Bad call to x_coord\n");*/
  return (c->col_origin[col]);
}

int y_coord(int row,Canvas *c) {
    if (row < 0) row = 0;
    /*    if (c->row_origin[1] != DEFCELLHEIGHT) 
      fprintf(stderr,"Bad call to y_coord\n");*/
    return(c->row_origin[row]);
}


int cell_col(int x, Canvas *c) {


  int i,j,size;
  
  if (x < 0) x = 0;
    
  for (i = DEFSHEETWIDTH/2, size = DEFSHEETWIDTH/4; ; ) {
    if (c->col_origin[i] > x) {
      i = i-size;
    } else if (c->col_origin[i] == x) {
      break;
    } else if (c->col_origin[i+1] < x) {
      i = i+size;
    } else if (c->col_origin[i+1] == x) {
      i = i+1; break;
    } else break;
    if (size > 1) size = size/2;
  }
  
  return(i);

}

int cell_row(int x,Canvas *c) {


  int i,j,size;

  if (x < 0) x = 0;  

  for (i = DEFSHEETWIDTH/2, size = DEFSHEETWIDTH/4; ; ) {
  
    if (c->row_origin[i] > x) {
      i = i-size;
    } else if (c->row_origin[i] == x) {
      break;
    } else if (c->row_origin[i+1] < x) {
      i = i+size;
    } else if (c->row_origin[i+1] == x) {
      i = i+1; break;
    } else 
      break;
    if (size > 1) size = size/2;
  }
  
  if (i < 0) 
    fprintf(stderr,"Bad row\n");

  return(i);

}

char *coltoa(int col) {
    static char rname[3];
    register char *p = rname;

    if (col >= 26) {
        *p++ = (col)/26 + 'A'-1;
        col = (col) % 26 ;
    }
    *p++ = col+'A';
    *p = '\0';
    return(rname);
}

char *coltoa_formated(int col) {
    static char rname[3];
    register char *p = rname;

    if (col >= 26) {
        *p++ = (col)/26 + 'A'-1;
        col = (col) % 26 ;
    }
    *p++ = col+'A';
    *p = '\0';
    if (col < 26) {
      *(p+1) = *p;
      *p = ' ';
    }
    return(rname);
}


char * cell_name_rc(short col, short row) {
    static char cell[10];

    sprintf(cell,"%s%d",coltoa(col),row+1);
    return(cell);
}

Canvas *get_canvas_info(char *pathname) {
    return(global_canvas_info);
}

double gettime(char *datestring, int format) {
  time_t tt;
  struct tm tms;


  sscanf(datestring,"%d/%d/%d",&(tms.tm_mon),&(tms.tm_mday),&(tms.tm_year));

  tms.tm_sec = 0;
  tms.tm_min = 0;
  tms.tm_hour = 0;
  tms.tm_wday = 0;
  tms.tm_yday = 0;
  tms.tm_isdst = 0;

  tms.tm_mon--; /* Because months are 0 to 11 on tms struct */
          
  tt = mktime(&tms);

  return((double)tt/SECONDS_IN_A_DAY+DAYS_BETWEEN_1970_1900);
}

/* $Log: cutils.c,v $
 * Revision 1.1  1998/08/17 20:23:26  cthulhu
 * Initial revision
 * */
