C  -------------------------------------------------------------------
C
C	Copyright (1990-1995) by Alexander Khibnik, Yuri Kuznetsov, and 
C	Eugene Nikolaev.
C
C The Locbif computation code in DsTool is distributed in the hope that it  
C will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty  
C of FITNESS FOR A PARTICULAR PURPOSE.  The software is provided as is without 
C any obligation on the part of Locbif authors, Cornell faculty, 
C Cornell staff or Cornell students to assist in its use, correction, 
C modification or enhancement. 
C
C  -------------------------------------------------------------------

C
      SUBROUTINE WRTDT (NX,NG,IADD,X0,HV0,EPS,FUN,IER,ISTOP)
C     3.05.90.
C     13.11.92
C     15.06.94
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*                                                                     *
C*    POPAMMA  WRTDT PEHAHAEHA  POBEPK PABHOCT         *
C*    AAH OPMAHX APAMETPOB POPAMM  BEETLE  BBOA X      *
C*    HA EAT.                                                       *
C*                                                                     *
C*  P MEHEH MAKCMAHOO CA EPEMEHHX HEOXOMO:           *
C*      1) MEHT PAMEPHOCT MACCBOB:FX0(NXC-1)  IVARS(NXC);      *
C*      2) MEHT HAEHE APAMETPA NXC;                            *
C*  P MEHEH MAKCMAHOO CA CCEEMX HK HEOXOMO:  *
C*      1) MEHT PAMEPHOCT MACCBA IFUNS(NUFC);                   *
C*      2) MEHT HAEHE APAMETPA  NUFC;                          *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      IMPLICIT REAL*8 (A-H,O-Z)
      IMPLICIT INTEGER*2 (I-N)
      include 'beetlebf.dim'
      EXTERNAL FUN
      DIMENSION X0(1), FX0(NDIM1), IADD(1)
C
      COMMON /ADD1A/ IPR, NSTEP, NCAN
      COMMON /ADD1B/ DX, HVMN, HVMX
      COMMON /ADD2A/ ICRS, IPRCRS
      COMMON /ADD2B/ EPSCRS
      COMMON /ADD3A/ NUF, IPRZER, IFUNS(IFMAX)
      COMMON /ADD3B/ EPSZER
      COMMON /ADD4A/ NUE, IPREXT, IVARS(NDIM)
      COMMON /ADD4B/ EPSEXT
      COMMON /ADD5A/ PXGMN, PXGMX
      COMMON /ADD6A/  XGMN,  XGMX
      COMMON /ADD7A/ EPSNWT
      COMMON /ADD7B/ ITNWT
C
C.... HAHAEHE HAEH APAMETPOB, AAHHX O MOAH.
C
      ISTOP= 0
      NXC  = NDIM
      NUFC = IFMAX
C.... 1) APAMETP, OTHOCEC K BEH O KPBO:
C
      IPR   = 0
      NSTEP = 1000
      NCAN  = 6
      DX    = 1.D-07
      HVMN  = DABS(HV0)*1.D-02
      HVMX  = DABS(HV0)*1.D+02
C
C.... 2) APAMETP, OTHOCEC K TOHEH TOEK CAMOEPECEEH:
C
      ICRS   = 1
      IPRCRS = 0
      EPSCRS = 10.D0*EPS
C
C.... 3) APAMETP, OTHOCEC K TOHEH HE AAHHX HK:
C
      NUF    = 0
      IPRZER = 0
      EPSZER = 10.D0*EPS
      DO 220 I=1,NUFC
         IFUNS(I) = I
 220  CONTINUE
C
C.... 4) APAMETP, OTHOCEC K TOHEH KCTPEMMOB AAHHX
C        KOOPHAT:
C
      NUE    = 0
      IPREXT = 0
      EPSEXT = 10.D0*EPS
      DO 260 I=1,NXC
         IVARS(I) = I
 260  CONTINUE
C
C.... 5) APAMETP, OTHOCEC K POEPE TOHEH EPBO TOK
C        HA KPBO:
C
      PXGMN = X0(NG) 
      PXGMX = X0(NG) 
C
C.... 6). APAMETP, OTHOCEC K AAH OCTMOO HTEPBAA
C         MEHEH  BEEHHO EPEMEHHO.
C
      XGMN = X0(NG) - 100.D0
      XGMX = X0(NG) + 100.D0
C
C.... 7). APAMETP, OTHOCEC K POEPE HTOHA:
C
      EPSNWT = EPS
      ITNWT  = 10
C
C.... KOPPEKTPOBKA APAMETPOB, AAHHX O MOAH, OOBATEEM.
C
      CALL BDATA
C
      IF (IADD(3) .EQ. 0) NUF = 0
      IF (IADD(4) .EQ. 0) NUE = 0
C
C.... EAT AAHHX APAMETPOB.
C
      IF (IPR .EQ. -2) RETURN
C
C..1. APAMETP, OTHOCEC K TOHEH TOEK HA KPBO.
C
      IER    =-1
#if defined(hib)
      WRITE (NCAN,1000)
      WRITE (NCAN,1001) NX
#endif
         IF (NX.LT.1 .OR. NX.GT.NXC)                     RETURN
#if defined(hib)
      WRITE (NCAN,1002) NG
#endif
         IF (NG.LT.1 .OR. NG.GT.NXC)                     RETURN
#if defined(hib)
      WRITE (NCAN,1004) (X0(I),I=1,NX)
#endif
      IERR = 0
      CALL FUN (X0,FX0,IERR,ISTOP)
      IF (ISTOP .NE. 0) RETURN
      IF (IERR  .EQ. 0) GOTO 500
#if defined(hib)
          WRITE (NCAN,3090)
#endif
          RETURN
 500  CONTINUE
      NFUN = NX - 1
#if defined(hib)
      WRITE (NCAN,1005) (FX0(I),I=1,NFUN)
      WRITE (NCAN,1007) HV0
#endif
         IF (DABS(HV0) .LE. 1.D-14)                      RETURN
#if defined(hib)
      WRITE (NCAN,1010) EPS
#endif
         IF (     EPS  .LE. 1.D-14)                      RETURN
      IF (IADD(1) .EQ. 0) GOTO 502
#if defined(hib)
          WRITE (NCAN,2000)
          WRITE (NCAN,2020)
          WRITE (NCAN,2000)
          WRITE (NCAN,1012) NSTEP
#endif
             IF (NSTEP .GE. 10000)                       RETURN
#if defined(hib)
          WRITE (NCAN,2030) NCAN
          WRITE (NCAN,1011) DX
#endif
             IF (DABS(DX) .LE. 1.D-14)                   RETURN
#if defined(hib)
          WRITE (NCAN,1008) HVMN
          WRITE (NCAN,1009) HVMX
#endif
          AHV0   = DABS(HV0)
             IF (.NOT.(HVMN.LE.AHV0 .AND. AHV0.LE.HVMX)) RETURN
 502  CONTINUE
C
C..2. APAMETP OTHOCEC K TOHEH TOEK CAMEPECEEH.
C
          IF (ICRS .EQ. 0) GOTO 510
#if defined(hib)
              WRITE (NCAN,2010)
              WRITE (NCAN,2080) EPSCRS
#endif
              IF (EPSCRS .LE. 1.D-14)                    RETURN
 510  CONTINUE
C
C..3. APAMETP, OTHOCEC K TOHEH HE HK.
C
      IF (IADD(3) .EQ. 0) GOTO 520
#if defined(hib)
          WRITE (NCAN,2000)
          WRITE (NCAN,2010)
          WRITE (NCAN,2000)
          WRITE (NCAN,2040) NUF
#endif
             IF (NUF .GT. NUFC)                          RETURN
#if defined(hib)
          WRITE (NCAN,2090) EPSZER
#endif
             IF (EPSZER .LE. 1.D-14)                     RETURN
#if defined(hib)
          IF (NUF .NE. 0) WRITE (NCAN,2050) (IFUNS(I),I=1,NUF)
#endif
          DO 518 I=1,NUFC
            IF (IFUNS(I) .LE. 0) RETURN
 518      CONTINUE
 520  CONTINUE
C
C..4. APAMETP, OTHOCEC K TOHEH KCTPEMMOB.
C
      IF (IADD(4) .EQ. 0) GOTO 530
#if defined(hib)
          WRITE (NCAN,2000)
          WRITE (NCAN,2010)
          WRITE (NCAN,2000)
          WRITE (NCAN,2060) NUE
#endif
             IF (NUE .GT. NXC)                           RETURN
#if defined(hib)
          WRITE (NCAN,3000) EPSEXT
#endif
             IF (EPSEXT .LE. 1.D-14)                     RETURN
#if defined(hib)
          IF (NUE .NE. 0) WRITE (NCAN,2070) (IVARS(I),I=1,NUE)
#endif
          DO 528 I=1,NXC
             IF (IVARS(I) .LE. 0) RETURN
 528      CONTINUE
 530  CONTINUE
C
C..5. APAMETP, OTHOCEC K TOHEH EPBO TOK HA KPBO.
C
      IF (IADD(5) .EQ. 0) GOTO 540
#if defined(hib)
          WRITE (NCAN,2000)
          WRITE (NCAN,2010)
          WRITE (NCAN,2000)
          WRITE (NCAN,3010) PXGMN, PXGMX
#endif
          IF (.NOT.(PXGMN.LE.X0(NG) .AND. X0(NG).LE.PXGMX)) RETURN
 540  CONTINUE
C
C..6. APAMETP, OTHOCEC K AAH OCTMOO HTEPBAA
C     MEHEH  BEEHHO EPEMEHHO.
C
      IF (IADD(6) .EQ. 0) GOTO 550
#if defined(hib)
          WRITE (NCAN,2000)
          WRITE (NCAN,2010)
          WRITE (NCAN,2000)
          WRITE (NCAN,1006) XGMN, XGMX
#endif
          IF (.NOT.(XGMN.LE.X0(NG) .AND. X0(NG).LE.XGMX)) RETURN
 550  CONTINUE
C
C..7. APAMETP, OTHOCEC K POEPE HTOHA:
C
      IF (IADD(7) .EQ. 0) GOTO 560
#if defined(hib)
          WRITE (NCAN,2000)
          WRITE (NCAN,2010)
          WRITE (NCAN,2000)
          WRITE (NCAN,3020) EPSNWT, ITNWT
#endif
 560  CONTINUE
#if defined(hib)
      WRITE (NCAN,1014)
#endif
      IER    = 0
      RETURN
C
C.... OPMAT COOEH.
#if defined(hib)
C
 1000 FORMAT
     A(////' ',119('=')//
     B '   HAEH APAMETPOB POPAMM  BEETLE :'/
     C '   -------------------------------------  ' )
C
 1001 FORMAT
     A('   CO EPEMEHHX:                      ',I5/)
C
 1002 FORMAT
     A('   HOMEP BEEHHO EPEMEHHO:           ',I5/)
C
 1004 FORMAT
     A('   KOOPHAT HAAHOO PEH X0:  '/
     B10(2X,7(G14.5,1X)/))
C
 1005 FORMAT
     A(/'   HAEH HK B TOKE X0:          '/
     B10(2X,7(G14.5,1X)/))
C
 3090 FORMAT
     A('   HE BCEH HAEH HK B TOKE X0')
C
 1006 FORMAT
     A(/'   HTEPBA MEHEH BEEHHO EPEMEHHO:'/
     B  '   MHMAHOE HAEHE:                 ',G14.5/
     C  '   MAKCMAHOE HAEHE:                ',G14.5/)
C
 1007 FORMAT
     A('   HAAH A BEH O KPBO:      ',G14.5/)
C
 1008 FORMAT
     A('   MHMAH A BEH O KPBO:    ',G14.5/)
C
 1009 FORMAT
     A('   MAKCMAH A BEH O KPBO:   ',G14.5)
C
 1010 FORMAT
     A('   TOHOCT OPEEEH TOK HA KPBO:  ',G14.5)
C
 1011 FORMAT
     A('   A CEHHOO EPEHPOBAH:      ',G14.2/)
C
 1012 FORMAT
     A('   MAKCMAHOE CO AOB BO KPBO: ',I5/)
C
 1014 FORMAT
     A(//1X,119('=')//)
C
 2000 FORMAT
     A(1X)
C
 2010 FORMAT
     A(1X,120('.'))
C
 2020 FORMAT
     A('   HAEH APAMETPOB OOHTEHX BOMOHOCTE: '/
     B '   ------------------------------------------------ ')
C
 2030 FORMAT
     A('   HOMEP KAHAA  BBOA PETATOB:   ',I5/)
C
 2040 FORMAT
     A('   CO CCEEMX HK HA KPBO:   ',I5/)
C
 2050 FORMAT
     A('   OPOK TOHEH HE:      '/2(30(1X,I3))/)
C
 2060 FORMAT
     A('   CO CCEEMX  KOOPHAT:          ',I5/)
C
 2070 FORMAT
     A('   OPOK TOHEH KCTPEMMOB:'/2(30(1X,I3))/)
C
 2080 FORMAT
     A('   TOHOCT TOHEH TOEK CAMOEPECEEH:',G14.5)
C
 2090 FORMAT
     A('   TOHOCT TOHEH KOOPHAT HE:    ',G14.5)
C
 3000 FORMAT
     A('   TOHOCT TOHEH KOOPHAT KCTPEMMOB:',G14.5)
C
 3010 FORMAT
     A('   P TOHEH EPBO TOK HA KPBO - TECTPETC'/
     B '   HTEPBA:  ',G14.5,'< X0(NG)<',G14.5)
C
 3020 FORMAT
     A( '   MATPA ACTHX POBOHX HE BCETC, EC:'
     B /'   OCTTA TOHOCT :           ',G14.5
     C /'   POEAHO HTOHOBCKX TEPA:',I5)
#endif
      END
