/*  -------------------------------------------------------------------

This program is the property of:

                             Cornell University 
                        Center for Applied Mathematics 
                              Ithaca, NY 14853

and may be used, modified and distributed freely, subject to the 
following restrictions:

       Any product which incorporates source code from the dstool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.

DsTool is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of FITNESS 
FOR A PARTICULAR PURPOSE.  The software is provided as is without 
any obligation on the part of Cornell faculty, staff or students to 
assist in its use, correction, modification or enhancement.

  -----------------------------------------------------------------  */
/*
 * parserwin_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `parserwin.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/icon_load.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include "parserwin_ui.h"

/*
 * Initialize an instance of object `win'.
 */
parserwin_win_objects *
parserwin_win_objects_initialize(ip, owner)
	parserwin_win_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (parserwin_win_objects *) calloc(1, sizeof (parserwin_win_objects))))
		return (parserwin_win_objects *) NULL;
	if (!ip->win)
		ip->win = parserwin_win_win_create(ip, owner);
	if (!ip->pan)
		ip->pan = parserwin_win_pan_create(ip, ip->win);
	if (!ip->name)
		ip->name = parserwin_win_name_create(ip, ip->pan);
	if (!ip->build)
		ip->build = parserwin_win_build_create(ip, ip->pan);
	if (!ip->type)
		ip->type = parserwin_win_type_create(ip, ip->pan);
	if (!ip->writec)
		ip->writec = parserwin_win_writec_create(ip, ip->pan);
	if (!ip->message)
		ip->message = parserwin_win_message_create(ip, ip->pan);
	if (!ip->textpane)
		ip->textpane = parserwin_win_textpane_create(ip, ip->win);
	return ip;
}

/*
 * Create object `win' in the specified instance.

 */
Xv_opaque
parserwin_win_win_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 431,
		XV_HEIGHT, 211,
		XV_LABEL, "Dynamical System Parser",
		XV_SHOW, TRUE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `pan' in the specified instance.

 */
Xv_opaque
parserwin_win_pan_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 72,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `name' in the specified instance.

 */
Xv_opaque
parserwin_win_name_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Panel_setting	parserwin_text_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 8,
		XV_WIDTH, 114,
		XV_HEIGHT, 15,
		PANEL_LABEL_STRING, "Name:",
		PANEL_VALUE_X, 74,
		PANEL_VALUE_Y, 8,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, parserwin_text_notify,
		NULL);
	return obj;
}

/*
 * Create object `build' in the specified instance.

 */
Xv_opaque
parserwin_win_build_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		parserwin_build_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 288,
		XV_Y, 12,
		XV_WIDTH, 49,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Build",
		PANEL_NOTIFY_PROC, parserwin_build_notify,
		NULL);
	return obj;
}

/*
 * Create object `type' in the specified instance.

 */
Xv_opaque
parserwin_win_type_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		parserwin_settings_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 32,
		XV_WIDTH, 200,
		XV_HEIGHT, 23,
		PANEL_VALUE_X, 69,
		PANEL_VALUE_Y, 32,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LABEL_STRING, "Type:",
		PANEL_NOTIFY_PROC, parserwin_settings_notify,
		PANEL_CHOICE_STRINGS,
			"Vector field",
			"Mapping",
			0,
		NULL);
	return obj;
}

/*
 * Create object `writec' in the specified instance.

 */
Xv_opaque
parserwin_win_writec_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern void		parserwin_writec_notify();
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 288,
		XV_Y, 40,
		XV_WIDTH, 104,
		XV_HEIGHT, 19,
		PANEL_LABEL_STRING, "Write C code...",
		PANEL_NOTIFY_PROC, parserwin_writec_notify,
		NULL);
	return obj;
}

/*
 * Create object `message' in the specified instance.

 */
Xv_opaque
parserwin_win_message_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 44,
		XV_WIDTH, 0,
		XV_HEIGHT, 0,
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `textpane' in the specified instance.

 */
Xv_opaque
parserwin_win_textpane_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 70,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, TRUE,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `editCwin'.
 */
parserwin_editCwin_objects *
parserwin_editCwin_objects_initialize(ip, owner)
	parserwin_editCwin_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (parserwin_editCwin_objects *) calloc(1, sizeof (parserwin_editCwin_objects))))
		return (parserwin_editCwin_objects *) NULL;
	if (!ip->editCwin)
		ip->editCwin = parserwin_editCwin_editCwin_create(ip, owner);
	if (!ip->editCtextpane)
		ip->editCtextpane = parserwin_editCwin_editCtextpane_create(ip, ip->editCwin);
	return ip;
}

/*
 * Create object `editCwin' in the specified instance.

 */
Xv_opaque
parserwin_editCwin_editCwin_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 601,
		XV_HEIGHT, 582,
		XV_LABEL, "Dynamical System Definition Editor",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, FALSE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `editCtextpane' in the specified instance.

 */
Xv_opaque
parserwin_editCwin_editCtextpane_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, TRUE,
		NULL);
	return obj;
}

