/*  -------------------------------------------------------------------

This program is the property of:

                             Cornell University 
                        Center for Applied Mathematics 
                              Ithaca, NY 14853

and may be used, modified and distributed freely, subject to the 
following restrictions:

       Any product which incorporates source code from the dstool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.

DsTool is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of FITNESS 
FOR A PARTICULAR PURPOSE.  The software is provided as is without 
any obligation on the part of Cornell faculty, staff or students to 
assist in its use, correction, modification or enhancement.

  -----------------------------------------------------------------  */
/*
 * porbit_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `porbit.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "porbit_ui.h"

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

void
main(argc, argv)
	int		argc;
	char		**argv;
{
	porbit_win_objects	*porbit_win;
	
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, 0);
	INSTANCE = xv_unique_key();
	
	/*
	 * Initialize user interface components.
	 */
	porbit_win = porbit_win_objects_initialize(NULL, NULL);
	
	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(porbit_win->win);
	exit(0);
}

#endif

/*
 * Notify callback function for `var'.
 */
void
porbit_settings_notify(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
	porbit_win_objects	*ip = (porbit_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fprintf(stderr, "porbit: porbit_settings_notify: value: %u\n", value);
}

/*
 * Notify callback function for `value'.
 */
Panel_setting
porbit_text_notify(item, event)
	Panel_item	item;
	Event		*event;
{
	porbit_win_objects	*ip = (porbit_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	char *	value = (char *) xv_get(item, PANEL_VALUE);
	
	fprintf(stderr, "porbit: porbit_text_notify: value: %s\n", value);
	return panel_text_notify(item, event);
}

/*
 * Notify callback function for `go'.
 */
void
porbit_go_notify(item, event)
	Panel_item	item;
	Event		*event;
{
	porbit_win_objects	*ip = (porbit_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	fputs("porbit: porbit_go_notify\n", stderr);
}

