/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:42 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 5 */

/*
 * This function contains 75 FP additions, 52 FP multiplications,
 * (or, 57 additions, 34 multiplications, 18 fused multiply/add),
 * 27 stack variables, and 40 memory accesses
 */
static const fftw_real K250000000 = FFTW_KONST(+0.250000000000000000000000000000000000000000000);
static const fftw_real K559016994 = FFTW_KONST(+0.559016994374947424102293417182819058860154590);
static const fftw_real K587785252 = FFTW_KONST(+0.587785252292473129168705954639072768597652438);
static const fftw_real K951056516 = FFTW_KONST(+0.951056516295153572116439333379382143405698634);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_5(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (5 * iostride);
     {
	  fftw_real tmp89;
	  fftw_real tmp86;
	  fftw_real tmp87;
	  fftw_real tmp82;
	  fftw_real tmp90;
	  fftw_real tmp85;
	  fftw_real tmp88;
	  fftw_real tmp91;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp89 = X[0];
	  {
	       fftw_real tmp80;
	       fftw_real tmp81;
	       fftw_real tmp83;
	       fftw_real tmp84;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp80 = X[iostride];
	       tmp81 = X[4 * iostride];
	       tmp86 = tmp80 + tmp81;
	       tmp83 = X[2 * iostride];
	       tmp84 = X[3 * iostride];
	       tmp87 = tmp83 + tmp84;
	       tmp82 = tmp80 - tmp81;
	       tmp90 = tmp86 + tmp87;
	       tmp85 = tmp83 - tmp84;
	  }
	  Y[-iostride] = -((K951056516 * tmp82) + (K587785252 * tmp85));
	  Y[-2 * iostride] = (K951056516 * tmp85) - (K587785252 * tmp82);
	  X[0] = tmp89 + tmp90;
	  tmp88 = K559016994 * (tmp86 - tmp87);
	  tmp91 = tmp89 - (K250000000 * tmp90);
	  X[iostride] = tmp88 + tmp91;
	  X[2 * iostride] = tmp91 - tmp88;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 4) {
	  fftw_real tmp32;
	  fftw_real tmp71;
	  fftw_real tmp61;
	  fftw_real tmp64;
	  fftw_real tmp68;
	  fftw_real tmp69;
	  fftw_real tmp70;
	  fftw_real tmp73;
	  fftw_real tmp72;
	  fftw_real tmp43;
	  fftw_real tmp54;
	  fftw_real tmp55;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp32 = X[0];
	  tmp71 = Y[-4 * iostride];
	  {
	       fftw_real tmp37;
	       fftw_real tmp59;
	       fftw_real tmp53;
	       fftw_real tmp63;
	       fftw_real tmp42;
	       fftw_real tmp60;
	       fftw_real tmp48;
	       fftw_real tmp62;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp34;
		    fftw_real tmp36;
		    fftw_real tmp33;
		    fftw_real tmp35;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp34 = X[iostride];
		    tmp36 = Y[-3 * iostride];
		    tmp33 = c_re(W[0]);
		    tmp35 = c_im(W[0]);
		    tmp37 = (tmp33 * tmp34) - (tmp35 * tmp36);
		    tmp59 = (tmp35 * tmp34) + (tmp33 * tmp36);
	       }
	       {
		    fftw_real tmp50;
		    fftw_real tmp52;
		    fftw_real tmp49;
		    fftw_real tmp51;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp50 = X[3 * iostride];
		    tmp52 = Y[-iostride];
		    tmp49 = c_re(W[2]);
		    tmp51 = c_im(W[2]);
		    tmp53 = (tmp49 * tmp50) - (tmp51 * tmp52);
		    tmp63 = (tmp51 * tmp50) + (tmp49 * tmp52);
	       }
	       {
		    fftw_real tmp39;
		    fftw_real tmp41;
		    fftw_real tmp38;
		    fftw_real tmp40;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp39 = X[4 * iostride];
		    tmp41 = Y[0];
		    tmp38 = c_re(W[3]);
		    tmp40 = c_im(W[3]);
		    tmp42 = (tmp38 * tmp39) - (tmp40 * tmp41);
		    tmp60 = (tmp40 * tmp39) + (tmp38 * tmp41);
	       }
	       {
		    fftw_real tmp45;
		    fftw_real tmp47;
		    fftw_real tmp44;
		    fftw_real tmp46;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp45 = X[2 * iostride];
		    tmp47 = Y[-2 * iostride];
		    tmp44 = c_re(W[1]);
		    tmp46 = c_im(W[1]);
		    tmp48 = (tmp44 * tmp45) - (tmp46 * tmp47);
		    tmp62 = (tmp46 * tmp45) + (tmp44 * tmp47);
	       }
	       tmp61 = tmp59 - tmp60;
	       tmp64 = tmp62 - tmp63;
	       tmp68 = tmp59 + tmp60;
	       tmp69 = tmp62 + tmp63;
	       tmp70 = tmp68 + tmp69;
	       tmp73 = tmp48 - tmp53;
	       tmp72 = tmp37 - tmp42;
	       tmp43 = tmp37 + tmp42;
	       tmp54 = tmp48 + tmp53;
	       tmp55 = tmp43 + tmp54;
	  }
	  X[0] = tmp32 + tmp55;
	  {
	       fftw_real tmp65;
	       fftw_real tmp67;
	       fftw_real tmp58;
	       fftw_real tmp66;
	       fftw_real tmp56;
	       fftw_real tmp57;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp65 = (K951056516 * tmp61) + (K587785252 * tmp64);
	       tmp67 = (K951056516 * tmp64) - (K587785252 * tmp61);
	       tmp56 = K559016994 * (tmp43 - tmp54);
	       tmp57 = tmp32 - (K250000000 * tmp55);
	       tmp58 = tmp56 + tmp57;
	       tmp66 = tmp57 - tmp56;
	       Y[-4 * iostride] = tmp58 - tmp65;
	       X[iostride] = tmp58 + tmp65;
	       X[2 * iostride] = tmp66 - tmp67;
	       Y[-3 * iostride] = tmp66 + tmp67;
	  }
	  Y[0] = tmp70 + tmp71;
	  {
	       fftw_real tmp74;
	       fftw_real tmp79;
	       fftw_real tmp77;
	       fftw_real tmp78;
	       fftw_real tmp75;
	       fftw_real tmp76;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp74 = (K951056516 * tmp72) + (K587785252 * tmp73);
	       tmp79 = (K951056516 * tmp73) - (K587785252 * tmp72);
	       tmp75 = K559016994 * (tmp68 - tmp69);
	       tmp76 = tmp71 - (K250000000 * tmp70);
	       tmp77 = tmp75 + tmp76;
	       tmp78 = tmp76 - tmp75;
	       X[4 * iostride] = -(tmp74 + tmp77);
	       Y[-iostride] = tmp77 - tmp74;
	       X[3 * iostride] = -(tmp78 - tmp79);
	       Y[-2 * iostride] = tmp79 + tmp78;
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp11;
	  fftw_real tmp24;
	  fftw_real tmp14;
	  fftw_real tmp26;
	  fftw_real tmp15;
	  fftw_real tmp30;
	  fftw_real tmp4;
	  fftw_real tmp18;
	  fftw_real tmp7;
	  fftw_real tmp20;
	  fftw_real tmp8;
	  fftw_real tmp29;
	  fftw_real tmp31;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  {
	       fftw_real tmp10;
	       fftw_real tmp9;
	       fftw_real tmp23;
	       fftw_real tmp13;
	       fftw_real tmp12;
	       fftw_real tmp25;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp10 = X[2 * iostride];
	       tmp9 = c_re(W[1]);
	       tmp11 = tmp9 * tmp10;
	       tmp23 = c_im(W[1]);
	       tmp24 = tmp23 * tmp10;
	       tmp13 = X[3 * iostride];
	       tmp12 = c_re(W[2]);
	       tmp14 = tmp12 * tmp13;
	       tmp25 = c_im(W[2]);
	       tmp26 = tmp25 * tmp13;
	  }
	  tmp15 = tmp11 + tmp14;
	  tmp30 = tmp24 + tmp26;
	  {
	       fftw_real tmp3;
	       fftw_real tmp2;
	       fftw_real tmp17;
	       fftw_real tmp6;
	       fftw_real tmp5;
	       fftw_real tmp19;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp3 = X[iostride];
	       tmp2 = c_re(W[0]);
	       tmp4 = tmp2 * tmp3;
	       tmp17 = c_im(W[0]);
	       tmp18 = tmp17 * tmp3;
	       tmp6 = X[4 * iostride];
	       tmp5 = c_re(W[3]);
	       tmp7 = tmp5 * tmp6;
	       tmp19 = c_im(W[3]);
	       tmp20 = tmp19 * tmp6;
	  }
	  tmp8 = tmp4 + tmp7;
	  tmp29 = tmp18 + tmp20;
	  tmp31 = tmp29 + tmp30;
	  Y[0] = tmp31;
	  Y[-iostride] = (K559016994 * (tmp29 - tmp30)) - (K250000000 * tmp31) - (K587785252 * (tmp11 - tmp14)) - (K951056516 * (tmp4 - tmp7));
	  {
	       fftw_real tmp21;
	       fftw_real tmp28;
	       fftw_real tmp27;
	       fftw_real tmp16;
	       fftw_real tmp22;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp21 = tmp18 - tmp20;
	       tmp28 = K559016994 * (tmp8 - tmp15);
	       tmp27 = tmp24 - tmp26;
	       tmp16 = tmp8 + tmp15;
	       tmp22 = tmp1 - (K250000000 * tmp16);
	       X[0] = tmp1 + tmp16;
	       X[iostride] = (K951056516 * tmp21) + tmp28 + tmp22 + (K587785252 * tmp27);
	       X[2 * iostride] = (K587785252 * tmp21) + tmp22 - (K951056516 * tmp27) - tmp28;
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4};
fftw_codelet_desc fftw_hc2hc_forward_5_desc =
{
     "fftw_hc2hc_forward_5",
     (void (*)()) fftw_hc2hc_forward_5,
     5,
     FFTW_FORWARD,
     FFTW_HC2HC,
     83,
     4,
     twiddle_order,
};
