## Copyright (C) 1996, 1997  Friedrich Leisch
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  four_normal_set (n)
##
## Returns a 4 class training set of size n consisting of four bivariate
## normals with unit variance centered around (+/- 1.5, +/- 1.5). The
## misclassification rate of the Bayesian classifier is 12.9 %.

## Author:  FL <Friedrich.Leisch@ci.tuwien.ac.at>
## Description:  Data for four normal classification problem
  
function [in, out] = four_normal_set (n) 
  
  n = ceil (n / 4);

  in = randn (n, 2) + ones (n, 1) * [1.5 1.5]; 
  in = [in; randn (n, 2) + ones (n, 1) * [-1.5 -1.5] ];
  in = [in; randn (n, 2) + ones (n, 1) * [1.5 -1.5] ];
  in = [in; randn (n, 2) + ones (n, 1) * [-1.5 1.5] ];
  
  out = ones (n,1) * [1 0 0 0];
  out = [ out; ones (n,1) * [0 1 0 0] ];
  out = [ out; ones (n,1) * [0 0 1 0] ];
  out = [ out; ones (n,1) * [0 0 0 1] ];
  
  k = rand (4 * n, 1);
  [dummy, kind] = sort (k);
  
  in = in (kind, :);
  out = out (kind, :);
  
endfunction
