## Copyright (C) 1996, 1997  Friedrich Leisch
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  spiral (n, m, s)

## Author:  FL <Friedrich.Leisch@ci.tuwien.ac.at>
## Description:  

function retval = spiral (n, m, s)
  
  N = m*n;
  
  t = (1:N)'/n;
  
  x = (2*t+1).*cos(2*pi*t)/3;
  y = (2*t+1).*sin(2*pi*t)/3;
  
  if (s != 0)
  
    e=s*randn(N,1);
  
    xs = cos(2*pi*t)-pi*(2*t+1).*sin(2*pi*t);
    ys = sin(2*pi*t)+pi*(2*t+1).*cos(2*pi*t);
  
    nrm = sqrt(sumsq([xs ys]'))';
  
    xs = xs./nrm;
    ys = ys./nrm;
  
    x = x + e.*ys;
    y = y - e.*xs;
  
  endif
  
  retval = [x, y];
  
endfunction
