/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef GUILE

/*
 * guilei.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include <signal.h>
#include <sys/wait.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>

#include "types.h"

#include "../xcommon/Animator.h"
#include "egon.h"

#include <guile/gh.h>

static int siag_row, siag_col;
static ani_object *siag_matrix;

static int guile_interpreter;

static SCM get_row()
{
	return gh_int2scm(siag_row);
}

static SCM get_col()
{
	return gh_int2scm(siag_col);
}

static SCM lexec_expr(SCM intp, SCM expr)
{
	exec_expr(name2interpreter(SCM_CHARS(intp)), SCM_CHARS(expr));
	return SCM_EOL;
}

/* Using Guile */

static SCM wrapper(void *data, SCM jmpbuf)
{
	char *scheme_code = (char *)data;
	return gh_eval_str(scheme_code);
}

static SCM catcher(void *data, SCM tag, SCM throw_args)
{
	char b[256];

	strcpy(b, "ERROR: ");
	strncat(b, (char *)data, 200);
	llpr(b);
	return SCM_BOOL_F;
}

/*
   This function was originally in cmds.c, but has been
   moved here because of its similarity to parse_expr.
 */
void execute_guile(char *s)
{
	if (ok2print)
		hide_cur(w_list);
	siag_row = 1;
	siag_col = 1;
	siag_matrix = w_list->buf->cast;
	gh_catch(SCM_BOOL_T,
			(scm_catch_body_t)wrapper, s,
			(scm_catch_handler_t)catcher, s);
	if (ok2print)
		show_cur(w_list);
}

static void execute_action(Widget w, XEvent * event,
			   String * params, Cardinal * num_params)
{
	char b[256];
	int i;

	strcpy(b, "(");
	strcat(b, params[0]);
	for (i = 1; i < *num_params; i++) {
		strcat(b, " ");
		strcat(b, params[i]);
	}
	strcat(b, ")");
#ifdef DEBUG
	printf("guile(%s)\n", b);
#endif
	exec_expr(guile_interpreter, b);
}

static XtActionsRec actions[] =
{
	{"guile", execute_action}
};

int init_guile_parser()
{
	XtAppContext app_context = XtWidgetToApplicationContext(topLevel);
	gh_new_procedure0_0("row", get_row);
	gh_new_procedure0_0("col", get_col);
	gh_new_procedure2_0("exec-expr", lexec_expr);

	XtAppAddActions(app_context, actions, XtNumber(actions));
	return guile_interpreter = register_interpreter("Guile",
				NULL, execute_guile);
}

#else
int guile_dummy;
#endif	/* GUILE */

