#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>
#include "../siod/siod.h"
#include "../common/cmalloc.h"
#include "../xcommon/Animator.h"
#include "../xcommon/dialogs.h"
#include "../xcommon/plugin.h"
#include "../xcommon/filesel.h"
#include "egon.h"

int select_file(char *path, char *name, char *patterns[], char *fmt)
{
        char extra[1024];
        sprintf(extra, "Home=%s:Examples=%s/examples/egon",
                getenv("HOME"), siagdocs);
        return fsel_input(topLevel, path, name, patterns, fmt,
                extra);
}

int alert_box(char *text, char *buttons[], int nbuttons)
{
        return alertbox(topLevel, text, buttons, nbuttons);
}

int select_from_list(char *text, char *choices[], int nchoices)
{
        return listsel(topLevel, text, choices, nchoices);
}

void error_box(char *message)
{
        errorbox(topLevel, message);
}

int egon_plugin_save(int ph, char *fn)
{
	return plugin_save(ph, fn);
}

static LISP lplugin_register(LISP desc, LISP ext, LISP cmd)
{
        plugin_register(get_c_string(desc),
                        get_c_string(ext),
                        get_c_string(cmd));
        return NIL;
}

#define PLUGIN_LINK 1
#define PLUGIN_COPY 2

static void insert_plugin(int mode, char *plugin_name)
{
        static char path[1024], name[1024];
        char fn[1024];
        char pn[1024];
        char cmd[1024];
        char fmt[80];
        char *p;
        buffer *buf = w_list->buf;
        int n;
        plugin_t plugin;

        /* ask for file name */
        if (path[0] == '\0') getcwd(path, 1024);
        name[0] = fn[0] = '\0';

        if (plugin_name) {
                char *q = strrchr(plugin_name, '/');
                if (q) strcpy(name, q+1);
                else strcpy(name, plugin_name);
                strcpy(fn, plugin_name);
        } else {
	        if (!select_file(path, name, plugin_patterns, fmt)) return;
        	sprintf(fn, "%s/%s", path, name);
	}
        plugin_unique_name(name, pn);

        plugin.row = 1;
        plugin.col = 1;
        plugin.displayed = 0;

        if (mode == PLUGIN_COPY) {
                plugin.name = cstrdup(pn);
                /* copy the file */
                p = plugin_basedir(buf, NULL);
                sprintf(pn, "%s/%s", p, plugin.name);
                sprintf(cmd, "(mkdir %s;cp %s %s)2>/dev/null", p, fn, pn);
                system(cmd);
        } else {
                strcpy(pn, fn);
                plugin.name = cstrdup(pn);
        }

        /* start the plugin */
        plugin.ph = plugin_start(pn);
        if (plugin.ph == -1) return;

        /* prepare the buffer */
        n = buf->nplugin++;
        buf->plugin = (plugin_t *)crealloc(buf->plugin,
                buf->nplugin*sizeof(plugin_t));
        buf->plugin[n] = plugin;
        buf->change = TRUE;
        pr_scr_flag = TRUE;
}

static LISP lplugin_import(LISP pn)
{
        if (NULLP(pn)) insert_plugin(PLUGIN_COPY, NULL);
        else insert_plugin(PLUGIN_COPY, get_c_string(pn));
        return NIL;
}

/* broken because it still takes the name relative to basedir */
static LISP lplugin_link(LISP pn)
{
        if (NULLP(pn)) insert_plugin(PLUGIN_LINK, NULL);
        else insert_plugin(PLUGIN_LINK, get_c_string(pn));
        return NIL;
}

/* return buffer's plug handler index or -1 for error */
static int select_plugin(buffer *b)
{
        char *plugin[20];
        int i;

        if (b->nplugin == 0) return -1;
        for (i = 0; i < 20 && i < b->nplugin; i++)
                plugin[i] = b->plugin[i].name;
        i = select_from_list("Select Plugin:", plugin, i);
        return i;
}

static LISP lplugin_export(void)
{
        int n;
        char fn[1024], pn[1024], cmd[1024], path[1024], fmt[80];
        buffer *buf = w_list->buf;

        /* pick plugin from list */
        n = select_plugin(buf);
        if (n == -1) return NIL;

        /* get description of the handler */
        /* ask for file name */
        getcwd(path, 1024);
        strcpy(fn, buf->plugin[n].name);
        if (!select_file(path, fn, NULL, fmt)) return NIL;

        /* save the file */
        sprintf(pn, "%s/%s", plugin_basedir(buf, NULL), buf->plugin[n].name);
        sprintf(cmd, "cp %s %s/%s", pn, path, fn);
        system(cmd);
        return NIL;
}

static LISP lplugin_delete(void)
{
        int n;
        buffer *buf = w_list->buf;

        /* pick plugin from list */
        n = select_plugin(buf);
        if (n == -1) return NIL;

        /* remove plugin */
        plugin_stop(buf->plugin[n].ph);
        cfree(buf->plugin[n].name);
        buf->nplugin--;
        for (; n < buf->nplugin; n++)
                buf->plugin[n] = buf->plugin[n+1];
        buf->change = pr_scr_flag = TRUE;
        return NIL;
}

static LISP lplugin_move(void)
{
        int n;
        buffer *buf = w_list->buf;

        /* pick plugin from list */
        n = select_plugin(buf);
        if (n == -1) return NIL;

        buf->plugin[n].row = 1;
        buf->plugin[n].col = 1;
        buf->change = pr_scr_flag = TRUE;
        return NIL;
}

/* this was copied from insert_plugin and botched to load an image file into
   the structured file system. It is not robust, can only be used in the
   way it is in egon.scm and will be replaced with something less crappy.
   I'm doing this to make Egon releaseable. Have mercy. */
static LISP limage_filename(void)
{
        static char path[1024], name[1024];
        char fn[1024];
        char pn[1024];
        char cmd[1024];
        char fmt[80];
        char *p;
        buffer *buf = w_list->buf;

        /* ask for file name */
        if (path[0] == '\0') getcwd(path, 1024);
        name[0] = fn[0] = '\0';

        if (!select_file(path, name, NULL, fmt)) return NIL;
        sprintf(fn, "%s/%s", path, name);
        plugin_unique_name(name, pn);
	strcpy(name, pn);

        /* copy the file */
        p = plugin_basedir(buf, NULL);
        sprintf(pn, "%s/%s", p, name);
        sprintf(cmd, "(mkdir %s;cp %s %s)2>/dev/null", p, fn, pn);
        system(cmd);

	/* and now we don't start a plugin, but return the filename */
	return strcons(strlen(pn), pn);
}

void interp_startup(void)
{
	init_subr_3("plugin-register", lplugin_register);
        init_subr_1("plugin-import", lplugin_import);
        init_subr_0("plugin-export", lplugin_export);
        init_subr_1("plugin-link", lplugin_link);
        init_subr_0("plugin-delete", lplugin_delete);
        init_subr_0("plugin-move", lplugin_move);
	init_subr_0("image-filename", limage_filename);
}

