/*
   Pathetic Writer
   Copyright (C) 1997, 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/AsciiText.h>

#include "../common/common.h"
#include "../common/cmalloc.h"
#include "../common/fonts.h"

#include "../xcommon/dialogs.h"
#include "../xcommon/embed.h"
#include "../xcommon/xcommon.h"
#include "../xcommon/filesel.h"

#include "../pw/pw.h"
#include "xpw.h"

#ifdef GUILE
#include <guile/gh.h>
#endif

#ifdef TCL
#include <tcl.h>
#endif

#include "../siod/siod.h"

extern int init_parser(int, char **);	/* siodi.c */
extern int init_guile_parser();
extern int init_tcl_parser();
extern void init_interpreters();

char *siaghome, *siaghelp, *siagdocs, *siag_basedir;
static char *pwrc;

int ok2print = 0;

int siod_interpreter;

extern void print_cells();

extern void mainloop(void);

#ifdef TCL
int Tcl_AppInit(Tcl_Interp *interp)
{
	init_tcl_parser(interp);
	mainloop();
	return TCL_OK;
}
#endif

extern void init_windows1(int *, char **);

void realmain(int argc, char **argv)
{
	char b[256], *home, *p;
	struct stat statbuf;

	buffer *buf = NULL;
	char path[1024];
	int i;

	if ((siaghome = getenv("SIAGHOME")) == NULL) {
		char env[256];
		sprintf(env, "SIAGHOME=%s", SIAGHOME);
		putenv(env);
		siaghome = SIAGHOME;
	}
	if ((siaghelp = getenv("SIAGHELP")) == NULL) {
		char env[256];
		sprintf(env, "SIAGHELP=%s", SIAGHELP);
		putenv(env);
		siaghelp = SIAGHELP;
	}
	if ((siagdocs = getenv("SIAGDOCS")) == NULL) {
		char env[256];
		sprintf(env, "SIAGDOCS=%s", SIAGDOCS);
		putenv(env);
		siagdocs = SIAGDOCS;
	}
        if ((p = getenv("SIAGLANG"))) {
                sprintf(b, "%s/common/dictionary.%s", siaghome, p);
                load_dictionary(b);
        }

	if ((home = getenv("HOME")) == NULL)
		home = "";
	sprintf(path, "%s/.siag", home);
	siag_basedir = cstrdup(path);
	mkdir(siag_basedir, 0700);
	sprintf(b, "%s/%ld", siag_basedir, (long)getpid());
	mkdir(b, 0700);
	sprintf(b, "%s/pw.scm", siag_basedir);
	pwrc = cstrdup(b);

	init_windows1(&argc, argv);

/* Start of oldmain() */
	init_interpreters();
	siod_interpreter = init_parser(argc, argv);
#ifdef GUILE
	init_guile_parser();
#endif
	interp_startup();
	waitforchild(0);
	buf = new_buffer("noname.pw", "noname.pw");

	init_windows(buf, argc, argv);
	init_position();
	init_cmds();

	sprintf(path, "%s/pw/pw.scm", siaghome);
	if (stat(path, &statbuf)) {
		char *buttons[] = {"OK"};

		fprintf(stderr, "Can't find the runtime library (pw.scm).\n");
		fprintf(stderr, "Expected it in %s\n", path);
		fprintf(stderr, "SIAGHOME is '%s'\n", siaghome);
		fprintf(stderr, "Please read installation instructions.\n");

		alert_box("Can't find pw.scm. Click to exit.", buttons, 1);
		exit(EXIT_FAILURE);
	}

	setvar(cintern("SIAGHOME"), strcons(-1, siaghome), NIL);
	setvar(cintern("SIAGHELP"), strcons(-1, siaghelp), NIL);
	setvar(cintern("SIAGDOCS"), strcons(-1, siagdocs), NIL);

	/* load runtime library */
	sprintf(b, "(load \"%s/pw/pw.scm\")", siaghome);
	execute(b);

	/* load user customizations, if any */
	if (!stat(pwrc, &statbuf)) {
		sprintf(b, "(load \"%s\")", pwrc);
		execute(b);
	}

	fileio_init();
	for (i = 1; i < argc; i++) {
		if (argv[i][0] != '-') {
			strcpy(path, argv[i]);
			buf = new_buffer(buffer_name(argv[i]), path);
			loadmatrix(path, buf, guess_file_format(path));
			w_list->buf = buf;
		}
	}
	pr_scr_flag = TRUE;

	/* this works, for reasons beyond my comprehension */
	execute("(print-version)");
	execute("(print-version)");
	activate_window(w_list);
#ifdef TCL
	Tcl_Main(argc, argv, Tcl_AppInit);
#else
	mainloop();
#endif
}

int main(int argc, char **argv)
{
#ifdef GUILE
	gh_enter(argc, argv, realmain);
#else
	realmain(argc, argv);
#endif
	return 0;
}

