#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>


#define NUMSTARS 3141 /* 3141 for full star catalog, decrease number for better
			performance, first N brighter stars are used */

#define NUMBODIES 22

#ifndef PI
#define PI 3.14159265358979323846
#endif

#define DATEOFELEMENTS 2450680.5 /* In Julian days */

#define RADIUSSCALE(x) ((x)*0.001)
#define DEG2RAD(x) ((x)*PI/180.0)
#define RAD2DEG(x) ((x)*180.0/PI)
#define DISTCORRECTION(x) ((x)*1.490)
#define DISTANCE(x,y,z) sqrt(x*x+y*y+z*z)


extern GLfloat LightPos[4];
extern GLfloat ambient[4];
extern GLfloat White[4];
extern GLfloat Black[4];
extern GLuint texName[NUMBODIES],texture,smodel,lighting,drawstars;
extern GLuint Stars,red,polaris;
extern int ImgWidth, ImgHeight;
extern GLenum ImgFormat;
extern GLfloat stars[NUMSTARS][4];
extern double days,timefactor;
extern char texturepath[100];
extern int SLICES,STACKS;

#define	SUN	0
#define	MERCURY	1
#define	VENUS	2
#define	EARTH	3
#define	MARS	4
#define	JUPITER	5
#define	SATURN	6
#define	URANUS	7
#define	NEPTUNE	8
#define	PLUTO	9
#define MOON	10
#define IO	11
#define EUROPA	12
#define GANYMEDE 13
#define CALLISTO 14
#define TETHYS	15
#define DIONE	16
#define RHEA	17
#define TITAN 	18
#define TRITON  19
#define CHARON  20
#define RINGS	21


typedef struct {
	char Name[20];
	GLUquadricObj *Object;
	GLuint Sphere;
	GLubyte *Image;
	int Sat;
	float DeltaRotation,Radius,Rotation,Degrees;
	float Inclination,AscendingNode,Perihelion,MeanDistance,DailyMotion;
	float Eccentricity,MeanLongitude;
	double posx,posy,posz;
} planetdata;


extern planetdata planets[NUMBODIES];
	
	

void Init(void);
void UpdatePositions(void);

