/* AMCL - A simple Mud CLient
 * Copyright (C) 1998 Robin Ericsson <lobbin@lobbin.ml.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "amcl.h"

ALIAS_DATA *alias_list;

void save_aliases (GtkWidget *button, gpointer data)
{
    gchar *home, filename[256] = "";
    FILE *fp;
    bool done = FALSE;
    gchar buf[256];
    gchar *alias, *replace;
    gint  row = 0;

    home = getenv ("HOME");

    snprintf (filename, 255, "%s%s", home, "/.amcl");
    if (check_amcl_dir (filename) != 0)
        return;

    snprintf (filename, 255, "%s%s", home, "/.amcl/aliases");

    fp = fopen (filename, "w");

    while ( !done )
    {
        if ( !gtk_clist_get_text ((GtkCList*) data, row, 0, &alias)
          || !gtk_clist_get_text ((GtkCList*) data, row, 1, &replace) )
            break;
            
        if ( alias[0] == '\0' )
        {
            done = TRUE;
            break;
        }

        fprintf (fp, "%s %s\n", alias, replace);
        row++;
    }

    if ( fp )
        fclose (fp);
    //g_free (home);

    return;
}

void load_aliases ( void )
{
    FILE *fp;
    gchar *home, filename[255] = "";
    gchar line[80+15+5];
    
    home = getenv ("HOME");

    snprintf (filename, 255, "%s%s", home, "/.amcl");
    if (check_amcl_dir (filename) != 0)
        return;


    snprintf (filename, 254, "%s%s", home, "/.amcl/aliases");

    fp = fopen (filename, "r");

    if ( fp == NULL )
        return;

    while ( fgets (line, 80+15+5, fp) != NULL )
    {
        gchar alias[15];
        gchar replace[80];

        sscanf (line, "%s %[^\n]", alias, replace);
        add_alias (alias, replace);
    }

    fclose (fp);
}

void  add_alias (char *alias, char *replacement)
{
    ALIAS_DATA *new_alias;

    new_alias = g_malloc0 (sizeof (ALIAS_DATA));
    
    new_alias->alias   = g_strdup (alias);
    new_alias->replace = g_strdup (replacement);

    new_alias->next = alias_list;
    alias_list      = new_alias;
}

void  insert_aliases  (GtkWidget *clist)
{
    ALIAS_DATA *alias;
    gchar *text[2];

    for ( alias = alias_list ; alias != NULL ; alias = alias->next )
    {
        text[0] = alias->alias;
        text[1] = alias->replace;
        gtk_clist_append (GTK_CLIST (clist), text);
    }
}
