/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * get_info.c,v 3.3 1998/03/29 23:03:07 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

void get_info()
{
	char *s, **t;
	if( version ){
		for( t = copyright; (s = *t); ++t ){
			fprintf( stderr, "%s\n", s );
		}
		fflush(stderr);
	}
	if( name && (s = strrchr(name, '/' )) ){
		name = s+1;
	}
	if( !strcasecmp( name, OFHP ) ){
		log(2,"of filter by name '%s'", name );
		of_filter = 1;
	} else if( format && *format == 'o' ){
		log(2,"of filter by format '%s'", format );
		of_filter = 1;
	}

	if( (s = getenv("RETRIES")) ){
		retries = atoi(s);
	}
	if( (s = getenv("SLEEPTIME")) ){
		wait_time = atoi(s);
	}
    if( (s = getenv("MODEL")) || (s = model_name) ){
		char buffer[128];
		buffer[sizeof(buffer)-1] = 0;
		strncpy( buffer, s, sizeof(buffer)-1 );
		for(s = buffer; *s ; ++s ) { if( isupper(*s) ) *s = tolower(*s);};
        if ( ! strcasecmp(buffer, "IV") )   model = IV ;
        if ( ! strcasecmp(buffer, "III") )   model = III ;
        if ( ! strcasecmp(buffer, "IIID") )  model = IIID ;
        if ( ! strcasecmp(buffer, "IIISi") ) model = IIISi ;
        if ( ! strcasecmp(buffer, "IVSi") ) model = IVSi ;
        if ( ! strcasecmp(buffer, "C5M") ) model = C5M ;
		if ( strstr(buffer, "si") ) Si_model = 1;
		log(4,"model_name %s, model %d", buffer, model );
    }
    if( (s = getenv("CARTRIDGE")) ){
		cartridge = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("RESOURCESAVE")) ){
		resourcesave = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("TRACE")) ){
		trace = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("WRAP")) ){
		wrap = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	if( (s = getenv("AUTODETECT")) ){
		autodetect = ( !strcasecmp(s,"ON") || !strcasecmp(s,"YES") );
	}
	/* set flags according to model */
	log(4,"model %d", model );
	switch( model ){
	default: break;
	case III:
		get_status = 0;
		nopjl = 1;
		break;
	case C5M:
		infostatus = 0;	/* do not send PJL INFOSTATUS request */
		break;
	}
}
