/*
 * rtmon.c		RTnetlink listener.
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 *
 * Authors:	Alexey Kuznetsov, <kuznet@ms2.inr.ac.ru>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <net/if.h>
#include <string.h>

#include "libnetlink.h"

static int init_phase = 1;

static int dump_msg(struct sockaddr_nl *who, struct nlmsghdr *n, void *arg)
{
	FILE *fp = (FILE*)arg;
	if (!init_phase) {
		char buf[128];
		struct nlmsghdr *n1 = (void*)buf;
		struct timeval tv;
		n1->nlmsg_type = 15;
		n1->nlmsg_flags = 0;
		n1->nlmsg_seq = 0;
		n1->nlmsg_pid = 0;
		n1->nlmsg_len = NLMSG_LENGTH(4*2);
		gettimeofday(&tv, NULL);
		((__u32*)NLMSG_DATA(n1))[0] = tv.tv_sec;
		((__u32*)NLMSG_DATA(n1))[1] = tv.tv_usec;
		fwrite((void*)n1, 1, NLMSG_ALIGN(n1->nlmsg_len), fp);
	}
	fwrite((void*)n, 1, NLMSG_ALIGN(n->nlmsg_len), fp);
	fflush(fp);
	return 0;
}

int
main(int argc, char **argv)
{
	FILE *fp;
	struct rtnl_handle rth;

	if (argc != 2) {
		fprintf(stderr, "Usage: rtmon <file>\n");
		exit(-1);
	}
	fp = fopen(argv[1], "w");
	if (fp == NULL) {
		perror("fopen");
		exit(-1);
	}

	if (rtnl_open(&rth, ~0U) < 0) {
		fprintf(stderr, "cannot open rtnetlink\n");
		exit(1);
	}

	if (rtnl_wilddump_request(&rth, AF_UNSPEC, RTM_GETLINK) < 0) {
		perror("cannot send dump request");
		exit(1);
	}

	init_phase = 0;

	if (rtnl_listen(&rth, dump_msg, (void*)fp) < 0)
		exit(2);

	exit(0);
}
