/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <pwd.h>

void chomp(char *);

int main(int argc, char **argv)
{
	FILE *pfile;
	struct passwd pw_local;

	char username[1024];
	char *passwd;
	char salt[3];
	char *cryptpass;
	uid_t uid;
	gid_t gid;
	char name[1024];
	char dir[1024];
	char shell[1024];	

	char temp[1024];	

	if (argc != 2)
	{
		printf ("authgen passwdfile\n");
		exit(1);
	}
	pfile = fopen (argv[1], "a");
	
	if (pfile == NULL)
	{
		printf ("Could not open authfile %s\n", argv[1]);
		exit(2);
	}

	printf ("Enter username: ");
	fgets(username, 1024, stdin);
	passwd = getpass("Enter password: ");
	printf ("Enter uid: ");
	fgets(temp, 1024, stdin);
	uid = atoi(temp);
	printf ("Enter gid: ");
	fgets(temp, 1024, stdin);
	gid = atoi(temp);
	printf ("Enter name: ");
	fgets(name, 1024, stdin);
	printf ("Enter home directory: ");
	fgets(dir, 1024, stdin);
	printf ("Enter shell: ");
	fgets(shell, 1024, stdin);

	salt[0] = 'a';
	salt[1] = 'a';
	salt[2] = '\0';

	cryptpass = (char *) crypt(passwd, salt);

	chomp (username);
	chomp (cryptpass);
	chomp (name);
	chomp (dir);
	chomp (shell);

	pw_local.pw_name = username;
	pw_local.pw_passwd = cryptpass;
	pw_local.pw_uid = uid;
	pw_local.pw_gid = gid;
	pw_local.pw_gecos = name;
	pw_local.pw_dir = dir;
	pw_local.pw_shell = shell;

	return putpwent(&pw_local, pfile);
}

void chomp (char *str)
{
	if (str[strlen(str) - 1] == '\n')
	{
		str[strlen(str) - 1] = '\0';
	}
}
