/* util.h
 * 
 * Copyright (c) 1992-1998 by Mike Gleason.
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 */

typedef int (*qsort_proc_t)(const void *, const void *);
typedef int (*bsearch_proc_t)(const void *, const void *);
typedef void (*sigproc_t)(int);
typedef volatile sigproc_t vsigproc_t;

#define STREQ(a,b) (strcmp(a,b) == 0)
#define STRNEQ(a,b,s) (strncmp(a,b,(size_t)(s)) == 0)

#ifndef ISTRCMP
#	ifdef HAVE_STRCASECMP
#		define ISTRCMP strcasecmp
#		define ISTRNCMP strncasecmp
#	else
#		define ISTRCMP strcmp
#		define ISTRNCMP strncmp
#	endif
#endif

#define ISTREQ(a,b) (ISTRCMP(a,b) == 0)
#define ISTRNEQ(a,b,s) (ISTRNCMP(a,b,(size_t)(s)) == 0)
#define YESNO(i) ((i == 0) ? "no" : "yes")
#define ONOFF(i) ((i == 0) ? "off" : "on")
#define TRUEFALSE(i) ((i == 0) ? "false" : "true")

#ifndef HAVE_STRCOLL
#	ifndef strcoll
#		define strcoll strcmp
#	endif
#	ifndef strncoll
#		define strncoll strncmp
#	endif
#endif

#define kOurDirectoryName	".ncftp"

#define kPasswordMagic "*encoded*"
#define kPasswordMagicLen 9

/* util.c */
void ToBase64(void *, const void *, size_t, int);
void FromBase64(void *, const void *, size_t, int);
void OutOfMemory(void);
void *Realloc(void *, size_t);
char *GetCWD(char *, size_t);
void MyInetAddr(char *, size_t, char **, int);
struct hostent *GetHostEntry(const char *, struct in_addr *);
void CompressPath(char *, const char *, const size_t);
void PathCat(char *, const size_t, const char *, const char *);
void AbbrevStr(char *, const char *, size_t, int);
char *Path(char *, size_t, char *, char *);
char *OurDirectoryPath(char *, size_t, char *);
void InitOurDirectory(void);
void InitUserInfo(void);
int MayUseFirewall(const char *const, int, const char *const);
int StrToBool(const char *const);
void AbsoluteToRelative(char *const, const size_t, const char *const, const char *const, const size_t);
int GetHostByName(char *const volatile, size_t, const char *const, int);
time_t UnDate(char *dstr);
void StrRemoveTrailingSlashes(char *);
int DecodeDirectoryURL(const FTPCIPtr, char *, LineListPtr, char *, size_t);

#if defined(HAVE_STRCOLL) && !defined(HAVE_STRNCOLL)
int strncoll(const char *a, const char *b, size_t n);
#endif
