/*
 * Copyright (c) 1990,1995 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <atalk/adouble.h>

/* XXX: this would benefit from pwrite. 
 *      locking has to be checked before each stream of consecutive
 *      ad_writes to prevent a lock in the middle from causing problems. 
 */
ssize_t ad_write( ad, eid, off, end, buf, buflen )
    struct adouble	*ad;
    const u_int32_t	eid;
    u_int32_t           off;
    const int		end;
    const char		*buf;
    const size_t	buflen;
{
    struct stat		st;
    ssize_t		cc;

    if ( eid == ADEID_DFORK ) {
	if ( end ) {
	    if ( fstat( ad->ad_df.adf_fd, &st ) < 0 ) {
		return( -1 );
	    }
	    off = st.st_size - off;
	}

	if ( ad->ad_df.adf_off != off ) {
	    if ( lseek( ad->ad_df.adf_fd, (off_t) off, SEEK_SET ) < 0 ) {
		return( -1 );
	    }
	    ad->ad_df.adf_off = off;
	}
	cc = write( ad->ad_df.adf_fd, buf, buflen );
	if ( cc < 0 ) {
	    return( -1 );
	}
	ad->ad_df.adf_off += cc;
    } else {
	if ( end ) {
	    off = ad->ad_eid[ eid ].ade_len - off;
	}

	if ( ad->ad_hf.adf_off != ad->ad_eid[ eid ].ade_off + off ) {
	    if ( lseek( ad->ad_hf.adf_fd, (off_t)
		    ad->ad_eid[ eid ].ade_off + off, SEEK_SET ) < 0 ) {
		return( -1 );
	    }
	    ad->ad_hf.adf_off = ad->ad_eid[ eid ].ade_off + off;
	}
	cc = write( ad->ad_hf.adf_fd, buf, buflen );
	if ( cc < 0 ) {
	    return( -1 );
	}

	if ( ad->ad_hf.adf_off < sizeof( ad->ad_data )) {
#define min(a,b)	((a)<(b)?(a):(b))
	    bcopy( buf, ad->ad_data + ad->ad_hf.adf_off,
		    min( sizeof( ad->ad_data ) - ad->ad_hf.adf_off, cc ));
	}

	ad->ad_hf.adf_off += cc;
	if ( ad->ad_eid[ eid ].ade_len < off + cc ) {
	    ad->ad_eid[ eid ].ade_len = off + cc;
	}
    }

    return( cc );
}

/* set locks here */
ad_rtruncate( ad, size )
    struct adouble	*ad;
    const size_t	size;
{
    if (ad_tmplock(ad, ADEID_RFORK, ADLOCK_WR, 0, 0, 0) < 0)
      return -2;

    if ( ftruncate( ad->ad_hf.adf_fd,
	    size + ad->ad_eid[ ADEID_RFORK ].ade_off ) < 0 ) {
        ad_tmplock(ad, ADEID_RFORK, ADLOCK_CLR, 0, 0, 0);
	return( -1 );
    }

    ad->ad_eid[ ADEID_RFORK ].ade_len = size;
    if ( lseek( ad->ad_hf.adf_fd, 0L, SEEK_SET ) < 0 ) {
        ad_tmplock(ad, ADEID_RFORK, ADLOCK_CLR, 0, 0, 0);
	return( -1 );
    }

    ad->ad_hf.adf_off = 0;
    ad_tmplock(ad, ADEID_RFORK, ADLOCK_CLR, 0, 0, 0);
    return( 0 );
}

int ad_dtruncate(ad, size)
    struct adouble	*ad;
    const size_t	size;
{
    int err;

    if (ad_tmplock(ad, ADEID_DFORK, ADLOCK_WR, 0, 0, 0) < 0)
      return -2;

    err = ftruncate(ad->ad_df.adf_fd, size);
    ad_tmplock(ad, ADEID_DFORK, ADLOCK_CLR, 0, 0, 0);

    return err;
}
