/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  menu.h
 * Purpose: Definitions for the menu display
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * BOOTP tags for the menu definition
 */
#define MENU_ID		128		/* magic and version numbers	*/
#define MENU_PARAMS	160		/* default menu parameters	*/
#define MENU_DISP_FIRST	184		/* first tag w/ display string	*/
#define MENU_DISP_LAST	191		/* last tag w/ display string	*/
#define MENU_IMG_FIRST	192		/* first tag w/ image desc	*/
#define MENU_IMG_LAST	207		/* last tag w/ image desc	*/

					/* max number of image desc	*/
#define MENU_IMG_NUM	(MENU_IMG_LAST - MENU_IMG_FIRST + 1)



/*
 **************************************************************************
 *
 * Magic ID and version numbers
 */
#define MENU_MAGIC	0x687445e4L		/* magic id number	*/
#define MENU_VER_MAJOR	0			/* major menu version	*/
#define MENU_VER_MINOR	1			/* minor menu version	*/



/*
 **************************************************************************
 *
 * Miscellaneous definitions.
 */
#define MAX_FNAM_LEN	BOOTP_FILE_SIZE		/* maximum filename len	*/
#define MAX_LABEL_LEN	32			/* maximum label length	*/



/*
 **************************************************************************
 *
 * Return codes for domenu()
 */
#define MENU_OK		0			/* no error		*/
#define MENU_ABORT	1			/* user wants to abort	*/
#define MENU_INVALID	2			/* menu is invalid	*/



/*
 **************************************************************************
 *
 * Functions in the menu module:
 */

/* Display a menu and adjust the BOOTP record accordingly */
extern int domenu __P((void));

