!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  string.S
!* Purpose: String and memory handling functions
!* Entries: _memcpy, _memcmp, _memset
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text

	public	_memcpy			! define entry points
	public	_memcmp
	public	_memset


!
!**************************************************************************
!
! Copy memory from second arg to first arg.
! Input:  1. arg  -  pointer to destination
!         2. arg  -  pointer to source
!         3. arg  -  number of bytes to copy
! Output: none
!
_memcpy:

	cld
	penter				! setup standard stack frame
	mov	dx,ds
	mov	bx,es
	mov	es,dx
	push	si
	push	di
	getcarg	(di,0)			! get destination pointer
	getcarg	(si,1)			! get source pointer
	getcarg	(cx,2)			! get number of bytes
	rep
	movsb				! do it
	pop	di
	pop	si
	mov	es,bx
	pleave
	ret


!
!**************************************************************************
!
! Compare memory.
! Input:  1. arg  -  pointer to first string
!         2. arg  -  pointer to second string
!         3. arg  -  number of bytes to compare
! Output: zero if equal, negative if 1. is lower, positive if 1. is higher
!
_memcmp:

	cld
	penter				! setup standard stack frame
	mov	dx,ds
	mov	bx,es
	mov	es,dx
	xor	ax,ax			! default return value
	push	si
	push	di
	getcarg	(di,0)			! get destination pointer
	getcarg	(si,1)			! get source pointer
	getcarg	(cx,2)			! get number of bytes
	repe
	cmpsb
	jz	mcmp9
	lodsb				! compare first nonmatch byte
	sub	al,[di]
	neg	al
	cbw
mcmp9:	pop	di
	pop	si
	mov	es,bx
	pleave
	ret


!
!**************************************************************************
!
! Fill memory block with a single value
! Input:  1. arg  -  pointer to destination
!         2. arg  -  value to fill memory with
!         3. arg  -  number of bytes to copy
! Output: none
!
_memset:

	cld
	penter				! setup standard stack frame
	mov	dx,ds
	mov	bx,es
	mov	es,dx
	push	di
	getcarg	(di,0)			! get destination pointer
	getcarg	(ax,1)			! get fill value
	getcarg	(cx,2)			! get number of bytes
	rep
	stosb				! do it
	pop	di
	mov	es,bx
	pleave
	ret


!
!**************************************************************************
!
	end

