! rmrd.S  -  DOS program to remove ramdisk
!
! Copyright (C) 1996-1998 Gero Kuhlmann   <gero@gkminix.han.de>
!
!  This program is free software; you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation; either version 2 of the License, or
!  any later version.
!
!  This program is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with this program; if not, write to the Free Software
!  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	.text

	.org	0x0100

	entry	start

start:	push	cs
	pop	ds
	xor	ax,ax
	mov	es,ax
	mov	si,#rdsig
	mov	di,#0xF1 * 4		! check ramdisk driver signature
	mov	cx,#4
	repz
	cmpsb
	jnz	start4

	mov	ax,#0x9C00
	int	0xF8			! check if a ramdisk driver is
	cmp	ax,#0x009C		! installed
	je	start1
start4:	mov	al,#1
	mov	dx,#noramd
	jmp	start9

start1:	mov	ax,#0x9C03
	int	0xF8			! get ramdisk ID
	or	cl,cl			! has to be drive A: (e.g. floppy)
	jz	start2
	mov	al,#2
	mov	dx,#noflop
	jmp	start9

start2:	mov	ax,#0x9C04
	int	0xF8			! remove ramdisk
	or	al,al
	jz	start3
	mov	al,#3
	mov	dx,#rderr
	jmp	start9

start3:	xor	al,al
	mov	dx,#rdok
start9:	push	ax
	mov	ah,#0x09
	int	0x21			! print error message
	mov	dx,#crlf
	mov	ah,#0x09
	int	0x21			! print CR/LF
	pop	ax
	mov	ah,#0x4C
	int	0x21			! terminate program


! Data area

rdsig:	.ascii	"NetB"
noramd:	.ascii	"No ramdisk found$"
noflop:	.ascii	"Ramdisk is not drive A:$"
rderr:	.ascii	"Can't remove ramdisk$"
rdok:	.ascii	"Ramdisk removed$"
crlf:	.byte	0x0D,0x0A
	.ascii	"$"

