/*
  $Id: cf.h,v 1.7 1997/01/16 21:00:50 luik Exp $

  cf.h - header for omirrd config file handling.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef CF_H_INCLUDED
#define CF_H_INCLUDED

#ifdef	__cplusplus
extern "C" {
#endif

typedef struct CfSubCmd_ *CfSubCmd;
typedef struct CfCmd_ *CfCmd;

#include "cfnl.h"
#include "conn.h"

typedef enum CfSubCmdType_ { SC_TYPE_INSTALL, SC_TYPE_EXCEPT } CfSubCmdType;

typedef struct CfSubCmd_ {
    CfSubCmdType sc_type;
    unsigned long sc_options;	/* INSTALL: install options */
    char *sc_name;		/* INSTALL: target directory name */
    CfNameList sc_args;		/* EXCEPT: except name list */
    CfSubCmd sc_next;
} CfSubCmdRec;


typedef enum CfCmdType_ { C_TYPE_ARROW } CfCmdType;

typedef struct CfCmd_ {
    CfCmdType c_type;
    char *c_name;		/* ARROW: hostname */
    ConnEntry c_conn;		/* connection data or CONN_OWN_HOST */
    char *c_label;		/* label for partial update */
    CfNameList c_files;		/* namelist of files to process */
    CfSubCmd c_subcmds;
    CfCmd c_next;
} CfCmdRec;

extern CfCmd cmds;

/* cf.c */
extern CfSubCmd cfAllocSubCmdEnt(int type);
extern void cfAddCmd(CfCmdType type, char *label, CfNameList files, CfNameList hosts, CfSubCmd subcmds);
extern void cfFreeCmds(void);
extern int cfFileMatch(char *path, ConnEntry e, char **targetpathp);
#ifdef DEBUG
extern void cfDebugCmd(char *prefix, CfCmd cmds);
#endif

/* cfparse.y */
extern int cfParse(char *filename);


#ifdef	__cplusplus
}
#endif

#endif /* defined(CF_H_INCLUDED) */
