# This is a special object that allows builders to use things like
# $thing to refer to the generic Thing when making a new object.

package Generics;
use strict;
use vars qw(@ISA);
use Thing;
use Error;
use ThingList;
@ISA=qw{Thing};

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $this  = Thing::new($class,@_);
	bless ($this, $class);
	return $this;
}

# This is the method that is called when we're looking for a generic object.
# Pass it the text that you're looking for, it'll return a generic thing if
# it can. The generic things are just all properties of this object that end
# in "_gen".
# Note this can also be called as a class method, in which case it'll look
# up the objects on the first generics object it can find.
sub findgeneric {
	my $this;
	if ($#_ > 0) {
		# Called as object method.
		$this=shift;
	}
	else {
		# Called as class method.
		$this=ThingList::FindByType("Generics");
		if (!$this) {
			return Error->new("No generic object.");
		}
	}
	my $want=lc(shift);

	if ($want=~/^\$?(\w+)/) {
		$want=$1."_gen";
		my $ret=$this->$want();
		if (! Error::iserror($ret)) {
			return $ret;
		}
	}
	else {
		return Error->new("generic called with invalid argument");
	}
}

1
