# This is a special room that holds LoginPeople before they login to the
# moo. It's a seperate class just so that the moo can easily look up the first
# LoginRoom and put new connections in it.

package LoginRoom;
use strict;
use vars qw(@ISA);
use Room;
use Verb;
use VerbCall;
use UNIVERSAL qw(isa);
use Version;
@ISA=qw{Room};

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $this  = Room::new($class,@_);
	bless ($this, $class);
	return $this;
}

# Display perlmoo version number first.
sub look {
	my $this=shift;
	
	return "** This server is running Perlmoo version ".$Version::version.". **",
		Room::look($this,@_);
}

1
