
# Command name: /crazy2
# Description:  Characters are displayed in different styles
#               (upper, lower, bold, underlined and reverse).
#               This is just a demo-script. You can see
#               here how you can add your own tkirc-scripts!
#
# Date:         03.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Changes:      03.03.98  Now this script can automatically be loaded
#                         from tkirc (~.tkirc/autoload/) and you
#                         don't need to change your tkircrc!
# Install:
#               1. copy this file to `~/.tkirc/autoload/crazy2.tcl'
#               2. reload your tkircrc or restart tkirc


proc on_command_crazy2 {window arguments} {
  set len [lLength "$arguments"]
  if {$len < 1} {
    print2crap "+++ Usage: /crazy2 \[( /msg | /notice | /describe ) <nick> | /me \] <message>"
    return
  }
  set command "" ; set newline ""
  if {[regexp -- {^(/msg|/notice|/describe) .*} "$arguments"]} {
    set command "[leftwords "$arguments" 2] "
    set arguments "[cutwords "$arguments" 2]"
  } elseif {[regexp -- {^(/me) .*} "$arguments"]} {
    set command "[leftwords "$arguments" 1] "
    set arguments "[cutwords "$arguments" 1]"
  }
  set next 0
  for {set i 0} {$i < [string length "$arguments"]} {incr i} {
    set char "[string index "$arguments" $i]"
    if {"$char" >= "A" && "$char" <= "z"} {
      if {[expr round(rand())] == 0} {
	append newline "\x02"
      }
      if {[expr round(rand())] == 0} {
	append newline "\x1f"
      }
      if {[expr round(rand())] == 0} {
	append newline "\x16"
      }
      if {$next == 0} {
	append newline "[string tolower "$char"]"
      } else {
	append newline "[string toupper "$char"]"
      }
      set next [expr ($next-1)*(-1)]
    } else {
      append newline "$char"
    }
  }
  send2irc "$command$newline"
}
