/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * $Log: PlextorReaderScan.h,v $
 * Revision 1.2  1998/09/27 19:20:05  mueller
 * Added retrieval of control nibbles for track with 'analyzeTrack()'.
 *
 * Revision 1.1  1998/09/07 15:15:40  mueller
 * Initial revision
 *
 */

#ifndef __PLEXTOR_READER_SCAN_H__
#define __PLEXTOR_READER_SCAN_H__

#include "PlextorReader.h"

class PlextorReaderScan : public PlextorReader {
public:

  PlextorReaderScan(ScsiIf *scsiIf, Toc *);
  static CdrDriver *instance(ScsiIf *scsiIf, Toc *);

protected:

  int analyzeTrack(int trackNr, long startLba, long endLba, Msf *index,
		   int *indexCnt, long *pregap, char *isrcCode,
		   unsigned char *ctl);

};

#endif
