"""
  PDA.Palm.App.Datebook - Date Book
  $Id: Datebook.py,v 1.4 1998/08/29 01:09:01 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.

  This module handles databases in the format used by the built-in
  Datebook application.
"""

__version__ = '$Id: Datebook.py,v 1.4 1998/08/29 01:09:01 rob Exp $'

import PDA.Palm
from PDA.Palm import _pdapalm, FLD_TIME_T, FLD_INT, FLD_UNKNOWN, FLD_STRING

_fields = { 'begin': (FLD_TIME_T, (0,0,0,0,0,0,0,0,0)),
	    'end': (FLD_TIME_T, None),
	    'alarm': (FLD_TIME_T, None),
	    'repeatWeekStart': (FLD_INT, 0),
	    'repeat': (FLD_UNKNOWN, None),
	    'repeatEnd': (FLD_UNKNOWN, None),
	    'exceptions': (FLD_UNKNOWN, None),
	    'description': (FLD_STRING, ''),
	    'note': (FLD_STRING, '')
	    }

class Record(PDA.Palm.Record):
    def __init__(self, *a, **kw):
	self.fields = _fields
	apply(PDA.Palm.Record.__init__, (self,)+a, kw)

    def unpack(self, raw):
	self.raw = raw
	_pdapalm.DatebookUnpack(self.data, raw)

    def pack(self):
	self.raw = _pdapalm.DatebookPack(self.data)
	return self.raw


class AppBlock(PDA.Palm.AppBlock):
    def __init__(self, *a, **kw):
	self.startOfWeek = 0
	apply(PDA.Palm.AppBlock.__init__, (self,)+a, kw)

    def unpack(self, raw):
	self.raw = raw
	_pdapalm.DatebookUnpackAppBlock(self.__dict__, raw)

    def pack(self):
	self.raw = _pdapalm.DatebookPackAppBlock(self.__dict__)
	return self.raw


class Database(PDA.Palm.Database):
    def __init__(self, *a, **kw):
	apply(PDA.Palm.Database.__init__, (self,)+a, kw)
	self.record_class = Record
	self.appblock_class = AppBlock

PDA.Palm.Types.register(Database, {'type':'DATA', 'creator': 'date'})

