# Copyright (c) 1997 Sun Microsystems, Inc.
# All rights reserved.
# 
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in
# all copies of this software.
# 
# IN NO EVENT SHALL SUN MICROSYSTEMS, INC. BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
# OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN
# MICROSYSTEMS, INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# SUN MICROSYSTEMS, INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THE SOFTWARE PROVIDED
# HEREUNDER IS ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS, INC. HAS NO
# OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
# MODIFICATIONS.
#
#  SyncMail conduit for PilotManager
#  Andy Poggio, 2/98
#
#  Adapted from SyncMemo by Alan Harder,
#  MemoEmailer by Martin von Weissenberg,
#  and pilot-mail.c by Kenneth Albanowski
#
#  ONLY SENDS MAIL FROM PILOT FOR NOW !!!
#
#  Ignores from, priority, and notification.
package SyncMail;

use Tk;
use TkUtils;
use strict;
use Data::Dumper;
use Carp;

#   $gHomeDirectory;		# base directory for files
my ($gConfigDialog);		# configuration dialog
my ($gDismissBtn);		# dismiss button on config dialog
my ($RCFILE);			# configuration file
my ($PREFS);			# configuration variables
my ($VERSION) = ("0.801");	# SyncMail version
my ($sendmail) = ("/usr/bin/fold -s -w 72 | /usr/lib/sendmail -t");
my ($SIGPREFID) = 3;
my ($OUTBOXCATEGORY) = 1;

sub conduitInit
{
    $RCFILE = "SyncMail/SyncMail.prefs";
    &loadPrefs;

    $PREFS->{"gHomeDirectory"} = "$ENV{HOME}/.pilotmgr/SyncMail"
	unless (defined($PREFS->{"gHomeDirectory"}));
}

sub conduitQuit
{
    &savePrefs;
}

sub conduitInfo
{
    return { "database" =>
		{
		    "name" => "MailDB",
		    "creator" => "mail",
		    "type" => "DATA",
		    "flags" => 0,
		    "version" => 0,
		},
	     "version" => $VERSION,
	     "author" => "Andy Poggio",
	     "email" => "andy.poggio\@Sun.COM" };
}

sub conduitConfigure
{
    my ($this, $wm) = @_;
    my ($frame, $obj, $subfr);

    unless (defined($gConfigDialog))
    {
	$gConfigDialog = $wm->Toplevel(-title => "Configuring SyncMail");
	$gConfigDialog->transient($wm);

	$frame = $gConfigDialog->Frame(-relief => "ridge", -bd => 4);
	$obj = TkUtils::Label($frame, "SyncMail Settings -- Only sends mail from Pilot");
	$obj->pack(-anchor => "c");

	$subfr = $frame->Frame;
	$obj = $subfr->Label(-text => "Mail directory: ");
	$obj->pack(-side => "left", -anchor => "nw", -fill => "x");

	$obj = $subfr->Entry(-textvariable => \$PREFS->{"gHomeDirectory"},
			     -relief => "sunken", -width => 60);
	$obj->pack(-side => "right", -anchor => "w", -fill => "x");
	$subfr->pack(-anchor => "e");
	$frame->pack(-side => 'top', -fill => 'x');

	$subfr = $frame->Frame;
	$gDismissBtn = TkUtils::Button($gConfigDialog, "Dismiss",
		sub{ &savePrefs; $gConfigDialog->withdraw });
	$gDismissBtn->pack(-side => 'bottom', -anchor => 'c');
	
	PilotMgr::setColors($gConfigDialog);
    }

    $gConfigDialog->Popup(-popanchor => 'c',
			  -popover => $wm,
			  -overanchor => 'c');
}


sub conduitSync
{
    my ($this, $dlp, $info) = @_;
    my ($record, %pilot);
    my ($appinfo, $cnt, $ret, $i, $sigpref, $signature, $line);
    my (@cats, %catcase, %catindx, $cat, @cat_ids, $pilot_dbhandle, $id);
    my ($dbinfo) = (&conduitInfo->{database});
    my ($dbname) = ($dbinfo->{name});

    # Open Pilot DB:
    eval
	{
	    $pilot_dbhandle = $dlp->open($dbname);
	};
    if ($@ =~ /read-only value/)
	{
	    PilotMgr::msg("Pilot database '$dbname' does not exist.\n");
	    croak($@);
	}
    elsif ($@)
	{
	    croak($@);
	}

    if (!defined($pilot_dbhandle))
    {
	PilotMgr::msg("Unable to open '$dbname'.  Aborting!");
	return;
    }

    # Let the user know what we're doing
    #
    $dlp->getStatus();

    $appinfo = $pilot_dbhandle->getAppBlock();

    # Get signature prefs
    $sigpref = $pilot_dbhandle->getPref( $SIGPREFID);
    $signature = $sigpref->{"signature"};

    # Read mail to be sent
    $i = 0;
    while (1)
    {
	$record = $pilot_dbhandle->getNextRecord( $OUTBOXCATEGORY);
	
	last if (!defined($record));
	next if ($record->{"deleted"} || $record->{"archived"});
	PilotMgr::status("Sending Pilot mail", 0);
	$line = $record->{"to"};
	if (!defined($line) || length($line)==0)
	{
	    PilotMgr::msg("Msg must have a To address.");
	    next;
	}
	$line = $record->{"body"};
	if (!defined($line) || length($line)==0)
	{
	    PilotMgr::msg("Msg must have a body.");
	    next;
	}


	$i++;
	
	open ( SM, join(" ", "|", $sendmail));
	PilotMgr::status("Sending Pilot mail", 50);


	$line = $record->{"to"};
	print( SM "To: " . $line . "\n");
	$line = $record->{"cc"};
	print( SM "Cc: " . $line . "\n") if (defined($line));
	$line = $record->{"bcc"};
	print( SM "Bcc: " . $line . "\n") if (defined($line));
	$line =  $record->{"replyTo"};
	print( SM "Reply-To: " . $line . "\n") if (defined($line));
	$line =  $record->{"subject"};
	print( SM "Subject: " . $line . "\n") if (defined($line));
	$line = "X-mailer: pilotmgr-mail-" . $VERSION . "\n";
	print( SM $line . "\n");
	$line =  $record->{"body"};
	print( SM $line . "\n");
	$line =  $record->{"signature"};
	print( SM $signature . "\n") if (defined($line) && $line);
	
	close( SM);
	
	$pilot_dbhandle->deleteRecord($record->{"id"});

	PilotMgr::status("Sending Pilot mail", 100);

    }
    PilotMgr::status("Sending Pilot mail", 100);

    undef $signature; # does this fix bug?
   
    &cleanupPilot($dlp, $pilot_dbhandle);

    $pilot_dbhandle->close();

    PilotMgr::msg("Sent " . $i . " msg(s).");

}

##########################################################################

sub loadPrefs
{
    my ($lines);

    open(FD, "<$RCFILE") || return;
    $lines = join('', <FD>);
    close(FD);
    eval $lines;

    # For some reason, we need to reference $PREFS here
    # or the preferences won't get loaded properly.
    #
    $PREFS;
}

sub savePrefs
{
    my ($var);

    $Data::Dumper::Purity = 1;
    $Data::Dumper::Deepcopy = 1;

    if (open(FD, ">$RCFILE"))
    {
	if (defined &Data::Dumper::Dumpxs)
	{
	    print FD Data::Dumper->Dumpxs([$PREFS], ['PREFS']);
	}
	else
	{
	    print FD Data::Dumper->Dump([$PREFS], ['PREFS']);
	}

	print FD "1;\n";
	close(FD);
    }
    else
    {
	PilotMgr::msg("Unable to save preferences to $RCFILE!");
    }
}

sub cleanupPilot
{
    my ($dlp_db, $pilot_dbhandle) = @_;
    $pilot_dbhandle->purge();
    $pilot_dbhandle->resetFlags();
}

sub fake_ceil
{
    my ($val) = (int($_[0]));

    return 1 if ($val == 0);
    return $val;
}


1;
