#! /bin/sh
#
# $Id: mkbltnmlst.sh,v 3.1.2.2 1997/04/30 06:32:19 hzoli Exp $
#
# Written by Andrew Main
#
srcdir=${srcdir-`echo $0|sed 's%/[^/][^/]*$%%'`}
test "x$srcdir" = "x$0" && srcdir=.
test "x$srcdir" = "x"   && srcdir=.
CFSED=${CFSED-"-f $srcdir/conf.sed"}
MODBINS=${MODBINS-modules-bltin}
XMODCF=${XMODCF-$srcdir/xmods.conf}
binmods=`sed 's/^/ /;s/$/ /' $MODBINS`
sed='/^[^:>!]*[>!][^:>!]*$/{
    s/[>!].*//
    p
}'
xmods=`sed -n $CFSED -e "$sed" $XMODCF`
trap "rm -f $1; exit 1" 1 2 15
exec > $1
echo "#ifdef DYNAMIC"
for mod in $xmods; do
    case $binmods in
	*" $mod "*) ;;
	*)  echo "/* non-linked-in known module \`$mod' */"
	    sed='/^ *'$mod' *[>!][^:>!]*$/{
                    s/.*[>!]//
                    p
                 }'
	    bins=`sed -n $CFSED -e "$sed" $XMODCF`
	    for bin in $bins; do
		echo "    add_autobin(\"$bin\", \"$mod\");"
	    done
	    sed='/^ *'$mod' *:[^:>!]*$/{
                     s/.*://
                     p
                 }'
	    deps=`sed -n $CFSED -e "$sed" $XMODCF`
	    for dep in $deps; do
		case $binmods in
		    *" $dep "*)
			echo "    /* depends on \`$dep' */" ;;
		    *)	echo "    add_dep(\"$mod\", \"$dep\");" ;;
		esac
	    done ;;
    esac
done
echo "#endif /* DYNAMIC */"
echo
donemods=" "
for mod in $binmods; do
    echo "/* linked-in module \`$mod' */"
    sed='/^ *'$mod' *:[^:>!]*$/{
             s/.*://
             p
         }'
    deps=`sed -n $CFSED -e "$sed" $XMODCF`
    for dep in $deps; do
	case $donemods in
	    *" $dep "*)
		echo "    /* depends on \`$dep' */" ;;
	    *)	echo >&2 "ERROR: linked-in module \`$mod' depends on \`$dep'"
		rm -f $1
		exit 1 ;;
	esac
    done
    echo "    mod.nam = \"$mod\"; boot_$mod(&mod);"
    donemods="$donemods$mod "
done
