
#ifndef _AUDIO_H
#define _AUDIO_H

#ifdef WITH_DMALLOC
#include <dmalloc.h>
#endif

#include <stdio.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#ifndef MIN
#include <sys/param.h>
#endif

#ifndef MAX
#define MAX(a,b)        (((a) > (b)) ? (a):(b))
#endif
#ifndef MIN
#define MIN(a,b)        (((a) < (b)) ? (a):(b))
#endif

#define MAX3(a,b,c)     (((a) > (b)) ? MAX(a, c) : MAX(b, c))


#include "../../config.h"
#include "audioconfig.h"
#include "buffer.h"
#include "audioIO.h"
#include "../econfig.h"

extern int AUDIO_BUFFER_SIZE;
extern int end_of_song;
extern int playing, paused;

void ChangeMasterVolume(int new_volume);
void ChangeBalance(int left, int right);
int GetVolume(int *left, int *right);
void set_bitrate(int bit);
void GetAudioStats(int *stereo, int *mono, int *bit, int *sample);
int setup_audio(int frequency, int stereo, int sign, int big, int sixteen);
void close_audio(void);


#define EMUSIC
#endif
