
#include "../emusic.h"

void do_action(int action)
{
   EDBUG(2, "do_action");
   switch (action) {
   case A_UNDEFINED:
   case A_NOTHING:
      break;
   case A_PLAY:
      control(PLAY);
      break;
   case A_PAUSE:
      control(PAUSE);
      break;
   case A_STOP:
      control(STOP);
      flush_audio();
      SetMultiButton(CurMW->playbutton, 1);
      break;
   case A_FF:
      control(CUE);
      break;
   case A_REW:
      control(REV);
      break;
   case A_DOWNTRACK:
      control(DNTRACK);
      flush_audio();
      break;
   case A_FIRST:
      control(FIRST);
      flush_audio();
      break;
   case A_UPTRACK:
      control(UPTRACK);
      flush_audio();
      break;
   case A_PLAYLIST_TOGGLE:
      TogglePlayWin();
      break;
   case A_LAST:
      control(LAST);
      flush_audio();
      break;
   case A_DIRECTACCESS:
      control(DIRECTACCESS);
      break;
   case A_MINIMIZE:
      MinimizeWidgets();
      break;
   case A_SHADE:
      MinMax_MainWin();
      break;
   case A_ICONIFY:
      break;
   case A_PLAYMODES:
      switchmodes();
      break;
   case A_PLAYTYPE:
      ChangePlayType();
      break;
   case A_RAISE_LOWER:
      break;
   case A_MOVE:
      break;
   case A_EXIT:
      Shutdown();
      break;
   case A_SORTLIST:
      sort_list(playlist, 1);
      break;
   case A_ADD_CD_TRACK:
      FileWin->cdmode = TRUE;
      SetFileBoxCallback(FileWin, PlayWin_Callback);
      actiontype = ADD;
      PopUpFileBox(FileWin);
      break;
   case A_ADD_TRACK:
      FileWin->cdmode = FALSE;
      SetFileBoxCallback(FileWin, PlayWin_Callback);
      actiontype = ADD;
      PopUpFileBox(FileWin);
      break;
   case A_DELETE_ALL:
      clearplaylist(playlist);
      CheckToPlay();
      DisplayListBox(listbox);
      break;
   case A_DELETE_ONE:
      delete_one(listbox->current_selection);
      CheckToPlay();
      DisplayListBox(listbox);
      break;
   case A_SAVE_LIST:
      FileWin->cdmode = FALSE;
      SetFileBoxCallback(FileWin, PlayWin_Callback);
      actiontype = SAVE;
      PopUpFileBox(FileWin);
      break;
   case A_LOAD_LIST:
      FileWin->cdmode = FALSE;
      SetFileBoxCallback(FileWin, PlayWin_Callback);
      actiontype = LOAD;
      PopUpFileBox(FileWin);
      break;
   case A_MOVE_DOWN:
      move_one(listbox->current_selection, 1);
      if ((listbox->list) && (listbox->list->last) &&
	  (listbox->current_selection != listbox->list->last->pos))
	 listbox->current_selection++;
      DisplayListBox(listbox);
      break;
   case A_MOVE_UP:
      move_one(listbox->current_selection, 0);
      if (listbox->current_selection != 1)
	 listbox->current_selection--;
      DisplayListBox(listbox);
      break;
   case A_SELECT_CUR_P:
      Select_Current(listbox->current_selection);
      break;
   case A_FILE_OK:
      FileWin->okdone = TRUE;
/*      KillFileBox(FileWin); */
      break;
   case A_FILE_CANCEL:
      FileWin->okdone = FALSE;
/*      KillFileBox(FileWin); */
      break;
   case A_SELECT_CUR_F:
/*      SelectCurrentFileFileBox(FileWin, FileWin->filelist->current_selection);
 */ break;
   case A_CHANGE_ANALYSIS:
      ToggleAnalysisType();
      break;
   case A_SHUFFLE:
      ShuffleIt();
      break;
   case A_NEWTHEME:
      FileWin->cdmode = FALSE;
      SetFileBoxCallback(FileWin, Theme_Callback);
      PopUpFileBox(FileWin);
      break;
   case A_TOGGLE_SIZE:
      ToggleSize();
      break;
   case A_MSG_OK:
      break;
   case A_MSG_CANCEL:
      break;
   default:
      break;
   }
   EDBUG_RETURN_;
}

int parse_action(char *text)
{
   int i;

   EDBUG(3, "parse_action");
   upstr(text);
   i = A_UNDEFINED;
   if (!strcmp("NOTHING", text))
      i = A_NOTHING;
   else if (!strcmp("NONE", text))
      i = A_NOTHING;
   else if (!strcmp("PLAY", text))
      i = A_PLAY;
   else if (!strcmp("PAUSE", text))
      i = A_PAUSE;
   else if (!strcmp("STOP", text))
      i = A_STOP;
   else if (!strcmp("FF", text))
      i = A_FF;
   else if (!strcmp("REW", text))
      i = A_REW;
   else if (!strcmp("DOWNTRACK", text))
      i = A_DOWNTRACK;
   else if (!strcmp("FIRST", text))
      i = A_FIRST;
   else if (!strcmp("TOGGLE_PLAYLIST", text))
      i = A_PLAYLIST_TOGGLE;
   else if (!strcmp("UPTRACK", text))
      i = A_UPTRACK;
   else if (!strcmp("LAST", text))
      i = A_LAST;
   else if (!strcmp("SEEK", text))
      i = A_DIRECTACCESS;
   else if (!strcmp("MINIMIZE", text))
      i = A_MINIMIZE;
   else if (!strcmp("ICONIFY", text))
      i = A_ICONIFY;
   else if (!strcmp("CHANGE_PLAYMODE", text))
      i = A_PLAYMODES;
   else if (!strcmp("CHANGE_PLAYTYPE", text))
      i = A_PLAYTYPE;
   else if (!strcmp("RAISE_LOWER", text))
      i = A_RAISE_LOWER;
   else if (!strcmp("MOVE", text))
      i = A_MOVE;
   else if (!strcmp("EXIT", text))
      i = A_EXIT;
   else if (!strcmp("SORTLIST", text))
      i = A_SORTLIST;
   else if (!strcmp("ADD_CD_TRACK", text))
      i = A_ADD_CD_TRACK;
   else if (!strcmp("ADD_TRACK", text))
      i = A_ADD_TRACK;
   else if (!strcmp("DELETE_ALL", text))
      i = A_DELETE_ALL;
   else if (!strcmp("DELETE", text))
      i = A_DELETE_ONE;
   else if (!strcmp("SAVE_LIST", text))
      i = A_SAVE_LIST;
   else if (!strcmp("LOAD_LIST", text))
      i = A_LOAD_LIST;
   else if (!strcmp("MOVE_UP", text))
      i = A_MOVE_UP;
   else if (!strcmp("MOVE_DOWN", text))
      i = A_MOVE_DOWN;
   else if (!strcmp("PLAYLIST_DOUBLECLICK", text))
      i = A_SELECT_CUR_P;
   else if (!strcmp("FILEBOX_OK", text))
      i = A_FILE_OK;
   else if (!strcmp("FILEBOX_CANCEL", text))
      i = A_FILE_CANCEL;
   else if (!strcmp("FILEBOX_DOUBLECLICK", text))
      i = A_SELECT_CUR_F;
   else if (!strcmp("CHANGE_ANALYSIS", text))
      i = A_CHANGE_ANALYSIS;
   else if (!strcmp("SHUFFLE", text))
      i = A_SHUFFLE;
   else if (!strcmp("NEWTHEME", text))
      i = A_NEWTHEME;
   else if (!strcmp("SHADE", text))
      i = A_SHADE;
   else if (!strcmp("TOGGLE_SIZE", text))
      i = A_TOGGLE_SIZE;
   else if (!strcmp("MSG_OK", text))
      i = A_MSG_OK;
   else if (!strcmp("MSG_CANCEL", text))
      i = A_MSG_CANCEL;
   else
      fprintf(stderr, "Action %s undefined..\n", text);
   EDBUG_RETURN(i);
}
