#include "widget.h"
#include "../econfig.h"

void HideBack(Background * back)
{
   EDBUG(6, "HideBack");
   if (back->visible) {
      XUnmapWindow(disp, back->win);
      back->visible = FALSE;
   }
   EDBUG_RETURN_;
}

void UnhideBack(Background * back)
{
   EDBUG(6, "UnhideBack");
   if (!back->visible) {
      XMapWindow(disp, back->win);
      back->visible = TRUE;
   }
   EDBUG_RETURN_;
}

void CreateBack(Background * back)
{
   XSetWindowAttributes xatrib;
   XTextProperty name;
   Atom wm_del_win;
   int MWMhints;

   EDBUG(5, "CreateBack");
   MWMhints = checkforMWM();
   wm_del_win = XInternAtom(disp, "WM_DELETE_WINDOW", False);
   if (back->shaped && !MWMhints)
      xatrib.override_redirect = TRUE;
   else
      xatrib.override_redirect = FALSE;
   back->win = XCreateWindow(disp, root, back->x, back->y, back->w, back->h, 0, depth, InputOutput, visual, CWOverrideRedirect, &xatrib);
   XSelectInput(disp, back->win, StructureNotifyMask | ExposureMask | EnterWindowMask | LeaveWindowMask | ButtonMotionMask | ButtonPressMask | ButtonReleaseMask | KeyPressMask);
   if (back->shaped && MWMhints)
      ESetBorderless(back->win);
   XMapWindow(disp, back->win);
   XStringListToTextProperty(&back->name, 1, &name);
   XSetWMName(disp, back->win, &name);
   Imlib_apply_image(imlib, back->back->im, back->win);
   XClearWindow(disp, back->win);
   XSetWMProtocols(disp, back->win, &wm_del_win, 1);
   back->visible = TRUE;
   back->exposed = FALSE;
   EDBUG_RETURN_;
}

void DefaultsBack(Background * back)
{
   back->x = back->y = back->w = back->h = 0;
   back->state = 1;
   back->exposed = FALSE;
   back->visible = TRUE;
   back->shaped = TRUE;
   back->name = Emalloc(32);
   back->back = NULL;
   strcpy(back->name, "eMusic ");
   strcat(back->name, VERSION);
}

Background *ConfigBack(FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   Background *back = Emalloc(sizeof(Background));

   EDBUG(5, "ConfigBack");
   DefaultsBack(back);
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("BACKGROUND", s1, 10)) {
	    back->back = LoadImage(s2);
	    back->w = back->back->w;
	    back->h = back->back->h;
	 }
	 else if (!strncmp("VISIBLE", s1, 7))
	    back->state = parsebool(s2);
	 else if (!strncmp("SHAPED", s1, 6))
	    back->shaped = parsebool(s2);
	 else if (!strncmp("NAME", s1, 4)) {
	    Efree(back->name);
	    back->name = duplicate(s2);
	 }
	 else if (!strncmp("LOCATION", s1, 8))
	    getcoords(s2, &back->x, &back->y);
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      CreateBack(back);
   EDBUG_RETURN(back);
}

void ResizeBack(Background * back, int new_w, int new_h)
{
   Pixmap p, m;

   EDBUG(5, "ResizeBack");
   if (!back)
      EDBUG_RETURN_;
   back->w = new_w;
   back->h = new_h;
   XResizeWindow(disp, back->win, back->w, back->h);
   /* 
    * This shouldn't really be necessary, but it seems X doesn't update what
    * you get from a XGetGeometry() call to the new window size anywhere near
    * to frequently.
    */
   Imlib_render(imlib, back->back->im, back->w, back->h);
   p = Imlib_move_image(imlib, back->back->im);
   m = Imlib_move_mask(imlib, back->back->im);
   XSetWindowBackgroundPixmap(disp, back->win, p);
   if (m) {
      XShapeCombineMask(disp, back->win, ShapeBounding, 0, 0, m, ShapeSet);
      Imlib_free_pixmap(imlib, m);
   }
   Imlib_free_pixmap(imlib, p);
   XClearWindow(disp, back->win);
   EDBUG_RETURN_;
}

void EventBack(Background * back, XEvent ev)
{
}

void FreeBack(Background * back)
{
   EDBUG(5, "FreeBack");
   if (!back)
      EDBUG_RETURN_;
   Efree(back->name);
   back->name = NULL;
   FreeImageDat(back->back);
   Efree(back);
   back = NULL;
   EDBUG_RETURN_;
}
