
#include "widget.h"
#include "../econfig.h"

void HideButton(Button * button)
{
   EDBUG(5, "HideButton");
   if (button->visible) {
      XUnmapWindow(disp, button->win);
      button->visible = FALSE;
   }
   EDBUG_RETURN_;
}

void UnhideButton(Button * button)
{
   EDBUG(5, "UnhideButton");
   if (!button->visible) {
      XMapWindow(disp, button->win);
      button->visible = TRUE;
   }
   EDBUG_RETURN_;
}

void HideMultiButton(MultiButton * mbutton)
{
   EDBUG(5, "HideMultiButton");
   if (mbutton->visible && mbutton->current) {
      HideButton(mbutton->current->button);
      mbutton->visible = FALSE;
   }
   EDBUG_RETURN_;
}

void UnhideMultiButton(MultiButton * mbutton)
{
   EDBUG(5, "UnhideMultiButton");
   if (!mbutton->visible) {
      UnhideButton(mbutton->current->button);
      mbutton->visible = TRUE;
   }
   EDBUG_RETURN_;
}

void SetButton(Button * button)
{
   EDBUG(5, "SetButton");
   if (!button->current)
      button->current = button->normal;
   Imlib_apply_image(imlib, button->current->im, button->win);
   XClearWindow(disp, button->win);
   button->exposed = FALSE;
   EDBUG_RETURN_;
}

void SetButtonBG(Button * button)
{
   EDBUG(5, "SetButtonBG");
   button->current = button->normal;
   SetButton(button);
   EDBUG_RETURN_;
}

void ClickButton(Button * button)
{
   EDBUG(5, "ClickButton");
   if (button->parts || !button->clicked || (button->current == button->clicked))
      EDBUG_RETURN_;
   button->current = button->clicked;
   SetButton(button);
   EDBUG_RETURN_;
}

void OverButton(Button * button)
{
   EDBUG(5, "OverButton");
   if (button->parts || !button->over || (button->current == button->over))
      EDBUG_RETURN_;
   button->current = button->over;
   SetButton(button);
   EDBUG_RETURN_;
}

void NormalButton(Button * button)
{
   EDBUG(5, "NormalButton");
   if (button->parts || !button->normal || (button->current == button->normal))
      EDBUG_RETURN_;
   button->current = button->normal;
   SetButton(button);
   EDBUG_RETURN_;
}

void SetButtonPart(Button * button, int x)
{
   int partHeight;
   ImageDat *i;
   static ImlibImage *im = NULL;

   EDBUG(5, "SetButtonPart");
   if (!button || !button->normal)
      EDBUG_RETURN_;
   i = button->normal;
   if ((button->currentPart == x) && (x != 0))
      EDBUG_RETURN_;
   if (im) {
      Imlib_kill_image(imlib, im);
      im = NULL;
   }
   if (i->h > i->w) {
      if (i->parts)
	 partHeight = i->h / i->parts;
      else
	 partHeight = i->h;
      if ((partHeight * (x + 1)) > i->im->rgb_height)
	 EDBUG_RETURN_;
      im = Imlib_crop_and_clone_image(imlib, i->im, 0, partHeight * x, i->w, partHeight);
   }
   else {
      if (i->parts)
	 partHeight = i->w / i->parts;
      else
	 partHeight = i->w;
      if ((partHeight * (x + 1)) > i->im->rgb_width)
	 EDBUG_RETURN_;
      im = Imlib_crop_and_clone_image(imlib, i->im, partHeight * x, 0, partHeight, i->h);
   }
   if (im) {
      Imlib_apply_image(imlib, im, button->win);
      XClearWindow(disp, button->win);
      button->currentPart = x;
   }
   EDBUG_RETURN_;
}

void CreateButton(Button * button, Window parent)
{
   int h = button->h;
   int w = button->w;

   EDBUG(5, "CreateButton");
   button->parent = parent;
   if (!button->parent)
      button->parent = root;
   if (button->parts) {
      if (button->h > button->w)
	 h = button->h / button->parts;
      else
	 w = button->w / button->parts;
   }
   button->win = CreateWin(button->parent, button->x, button->y, w, h);
   XMapWindow(disp, button->win);
   button->normal->parts = button->parts;
   if (!button->parts)
      SetButtonBG(button);
   else
      SetButtonPart(button, button->currentPart);
   if (!button->state)
      HideButton(button);
   EDBUG_RETURN_;
}

void DefaultsButton(Button * button)
{
   button->x = button->x = button->w = button->h = 0;
   button->normal = button->clicked = button->over = NULL;
   button->current = NULL;
   button->currentPart = 0;
   button->parts = 0;
   button->state = 1;
   button->exposed = 0;
   button->visible = TRUE;
   button->action_left = button->action_middle = button->action_right = 0;
}

Button *ConfigButton(Window parent, FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   Button *button = Emalloc(sizeof(Button));

   EDBUG(5, "ConfigButton");
   DefaultsButton(button);
   button->parent = parent;
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("#", s1, 1));
	 else if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("NORMAL", s1, 6)) {
	    button->normal = LoadImage(s2);
	    button->w = button->normal->w;
	    button->h = button->normal->h;
	 }
	 else if (!strncmp("CLICKED", s1, 7))
	    button->clicked = LoadImage(s2);
	 else if (!strncmp("MOUSEOVER", s1, 9))
	    button->over = LoadImage(s2);
	 else if (!strncmp("LOCATION", s1, 8))
	    getcoords(s2, &button->x, &button->y);
	 else if (!strncmp("PARTS", s1, 5))
	    button->parts = atoi(s2);
	 else if (!strncmp("VISIBLE", s1, 7))
	    button->state = parsebool(s2);
	 else if (!strncmp("ACTION_R", s1, 8))
	    button->action_right = parse_action(s2);
	 else if (!strncmp("ACTION_M", s1, 8))
	    button->action_middle = parse_action(s2);
	 else if (!strncmp("ACTION_L", s1, 8))
	    button->action_left = parse_action(s2);
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      CreateButton(button, parent);
   EDBUG_RETURN(button);
}

void MoveButton(Button * button, int x, int y)
{
   EDBUG(5, "MoveButton");
   button->x = x;
   button->y = y;
   XMoveWindow(disp, button->win, x, y);
   EDBUG_RETURN_;
}


void ResizeButton(Button * button, int new_w, int new_h)
{
   EDBUG(5, "ResizeButton");
   button->w = new_w;
   button->h = new_h;
   XResizeWindow(disp, button->win, new_w, new_h);
   if (button->normal)
      Imlib_render(imlib, button->normal->im, button->w, button->h);
   if (button->clicked)
      Imlib_render(imlib, button->clicked->im, button->w, button->h);
   if (button->over)
      Imlib_render(imlib, button->over->im, button->w, button->h);
   if (!button->parts)
      SetButton(button);
   else {
      int temp = button->currentPart;

      button->currentPart = 999;
      SetButtonPart(button, temp);
   }
   EDBUG_RETURN_;
}

void ScaleButton(Button * button, double scale_w, double scale_h)
{
   int w, h;

   EDBUG(5, "ScaleButton");
   button->x *= scale_w;
   button->y *= scale_h;
   button->w *= scale_w;
   button->h *= scale_h;
   w = button->w;
   h = button->h;
   if (button->parts) {
      if (button->h > button->w)
	 h = button->h / button->parts;
      else
	 w = button->w / button->parts;
   }
   XMoveResizeWindow(disp, button->win, button->x, button->y, w, h);
   if (button->normal)
      Imlib_render(imlib, button->normal->im, button->w, button->h);
   if (button->clicked)
      Imlib_render(imlib, button->clicked->im, button->w, button->h);
   if (button->over)
      Imlib_render(imlib, button->over->im, button->w, button->h);
   if (!button->parts)
      SetButton(button);
   else {
      int temp = button->currentPart;

      button->currentPart = 999;
      SetButtonPart(button, temp);
   }
   EDBUG_RETURN_;
}

void EventButton(Button * button, XEvent ev)
{
   static int inside = 0;

   EDBUG(5, "EventButton");
   if (ev.type == ButtonPress) {
      ClickButton(button);
      inside = TRUE;
   }
   else if (ev.type == EnterNotify) {
      if (ev.xcrossing.state)
	 ClickButton(button);
      else
	 OverButton(button);
      inside = TRUE;
   }
   else if (ev.type == LeaveNotify) {
      NormalButton(button);
      inside = FALSE;
   }
   else if (ev.type == ButtonRelease) {
      if (!inside)
	 EDBUG_RETURN_;
      inside = FALSE;
      NormalButton(button);
      if (ev.xbutton.button == 3 && !button->action_right)
	 ev.xbutton.button = 1;
      else if (ev.xbutton.button == 2 && !button->action_middle)
	 ev.xbutton.button = 1;
      if (ev.xbutton.button == 3)
	 do_action(button->action_right);
      else if (ev.xbutton.button == 2)
	 do_action(button->action_middle);
      else
	 do_action(button->action_left);
   }
   else if (ev.type == Expose)
      button->exposed = TRUE;
   EDBUG_RETURN_;
}

int isEventButton(Button * button, XEvent ev)
{
   EDBUG(5, "isEventButton");
   if (ev.xbutton.subwindow == button->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xcrossing.subwindow == button->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xbutton.window == button->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xcrossing.window == button->win) {
      EDBUG_RETURN(TRUE);
   }
   EDBUG_RETURN(FALSE);
}

void FreeButton(Button * button)
{
   EDBUG(5, "FreeButton");
   if (!button)
      EDBUG_RETURN_;
   FreeImageDat(button->normal);
   FreeImageDat(button->clicked);
   FreeImageDat(button->over);
   button->normal = NULL;
   Efree(button);
   button = NULL;
   EDBUG_RETURN_;
}

void CreateMultiButton(MultiButton * mbutton, Window parent)
{
   struct _multibutton *cur;

   EDBUG(5, "CreateMultiButton");
   if (!mbutton || !mbutton->first || !mbutton->last)
      EDBUG_RETURN_;
   cur = mbutton->last;
   while (cur != mbutton->first) {
      if (deferred)
	 CreateButton(cur->button, parent);
      HideButton(cur->button);
      cur = cur->prev;
   }
   if (deferred)
      CreateButton(mbutton->first->button, parent);
   UnhideButton(mbutton->first->button);
   mbutton->visible = TRUE;
   mbutton->current = mbutton->first;
   *(mbutton->var) = 0;
   if (!mbutton->state)
      HideMultiButton(mbutton);
   EDBUG_RETURN_;
}

void DefaultsMultiButton(MultiButton * mbutton)
{
   mbutton->number = 0;
   mbutton->state = 1;
   mbutton->first = mbutton->last = mbutton->current = NULL;
}

MultiButton *ConfigMultiButton(Window parent, FILE * file, int *var)
{
   struct _multibutton *cur = NULL;
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   MultiButton *mbutton = Emalloc(sizeof(MultiButton));

   EDBUG(5, "ConfigMultiButton");
   DefaultsMultiButton(mbutton);
   mbutton->var = var;
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("NUMBER", s1, 6))
	    mbutton->number = atoi(s2);
	 else if (!strncmp("VISIBLE", s1, 7))
	    mbutton->state = parsebool(s2);
	 else if (!strncmp("BEGIN", s1, 5)) {
	    if (!mbutton->first) {
	       mbutton->first = Emalloc(sizeof(struct _multibutton));

	       cur = mbutton->first;
	       cur->prev = NULL;
	       cur->next = NULL;
	    }
	    else {
	       cur->next = Emalloc(sizeof(struct _multibutton));

	       cur->next->prev = cur;
	       cur = cur->next;
	       cur->next = NULL;
	    }
	    cur->button = ConfigButton(parent, file);
	    mbutton->last = cur;
	 }
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      CreateMultiButton(mbutton, parent);
   EDBUG_RETURN(mbutton);
}

void SetVarMultiButton(MultiButton * mbutton, int *var)
{
   mbutton->var = var;
}

void SetMultiButton(MultiButton * mbutton, int number)
{
   struct _multibutton *cur;
   int counter = 1;

   EDBUG(5, "SetMultiButton");
   if (!mbutton || (number > mbutton->number))
      EDBUG_RETURN_;
   cur = mbutton->first;
   HideButton(mbutton->current->button);
   while (counter != number && cur) {
      cur = cur->next;
      if (cur == mbutton->last)
	 break;
   }
   mbutton->current = cur;
   *mbutton->var = number - 1;
   UnhideButton(mbutton->current->button);
   EDBUG_RETURN_;
}

void MoveMultiButton(MultiButton * mbutton, int x, int y)
{
   struct _multibutton *cur;

   EDBUG(5, "MoveMultiButton");
   if (!mbutton || !mbutton->first)
      EDBUG_RETURN_;
   cur = mbutton->first;
   while (cur) {
      MoveButton(cur->button, x, y);
      cur = cur->next;
   }
   EDBUG_RETURN_;
}

void ScaleMultiButton(MultiButton * mbutton, double scale_w, double scale_h)
{
   struct _multibutton *cur;

   EDBUG(5, "ScaleMultiButton");
   if (!mbutton || !mbutton->first)
      EDBUG_RETURN_;
   cur = mbutton->first;
   while (cur) {
      ScaleButton(cur->button, scale_w, scale_h);
      cur = cur->next;
   }
   EDBUG_RETURN_;
}

void EventMultiButton(MultiButton * mbutton, XEvent ev)
{
   EDBUG(5, "EventMultiButton");
   if (!mbutton || !mbutton->current)
      EDBUG_RETURN_;
   if (ev.type != ButtonRelease)
      EventButton(mbutton->current->button, ev);
   if (ev.type == ButtonRelease) {
      (*mbutton->var)++;
      if (*mbutton->var == mbutton->number)
	 *mbutton->var = 0;
      EventButton(mbutton->current->button, ev);
      HideButton(mbutton->current->button);
      if (mbutton->current == mbutton->last)
	 mbutton->current = mbutton->first;
      else
	 mbutton->current = mbutton->current->next;
      UnhideButton(mbutton->current->button);
   }
   EDBUG_RETURN_;
}

int isEventMultiButton(MultiButton * mbutton, XEvent ev)
{
   EDBUG(5, "isEventMultiButton");
   if (isEventButton(mbutton->current->button, ev))
      EDBUG_RETURN(TRUE);
   EDBUG_RETURN(FALSE);
}

void FreeMultiButton(MultiButton * mbutton)
{
   EDBUG(5, "FreeMultiButton");
   if (!mbutton || !mbutton->current)
      EDBUG_RETURN_;
   mbutton->current = mbutton->first;
   while (mbutton->current) {
      FreeButton(mbutton->current->button);
      mbutton->current = mbutton->current->next;
      if (mbutton->current) {
	 Efree(mbutton->current->prev);
	 mbutton->current->prev = NULL;
      }
   }
   Efree(mbutton->last);
   mbutton->last = NULL;
   mbutton->first = NULL;
   mbutton->current = NULL;
   Efree(mbutton);
   mbutton = NULL;
   EDBUG_RETURN_;
}
