
/* 
 * tplay - buffered audio player
 *
 * (c) 1997 ilkka karvinen <ik@iki.fi>
 *
 * Copyright under the GNU GENERAL PUBLIC LICENSE
 *   (see the file COPYING in this directory)
 *
 * 
 *   common functions
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <StringList.h>
#include "common.h"

DWORD read_big_endian_long(byte * buffer)
{
   DWORD byte0, byte1, byte2, byte3;

   byte0 = (DWORD) buffer[0];
   byte1 = (DWORD) buffer[1];
   byte2 = (DWORD) buffer[2];
   byte3 = (DWORD) buffer[3];
   return (byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3);
}

void write_big_endian_long(byte * buffer, DWORD value)
{
   buffer[0] = (byte) (value >> 24 & 0xFF);
   buffer[1] = (byte) (value >> 16 & 0xFF);
   buffer[2] = (byte) (value >> 8 & 0xFF);
   buffer[3] = (byte) (value & 0xFF);
}

DWORD read_little_endian_long(byte * buffer)
{
   DWORD byte0, byte1, byte2, byte3;

   byte0 = (DWORD) buffer[0];
   byte1 = (DWORD) buffer[1];
   byte2 = (DWORD) buffer[2];
   byte3 = (DWORD) buffer[3];
   return (byte3 << 24 | byte2 << 16 | byte1 << 8 | byte0);
}

WORD read_little_endian_word(byte * buffer)
{
   WORD byte0, byte1;

   byte0 = (WORD) buffer[0];
   byte1 = (WORD) buffer[1];
   return (byte1 << 8 | byte0);
}

void errprintf(char *fmt,...)
{
   va_list ap;

   va_start(ap, fmt);
   vfprintf(stderr, fmt, ap);
}

void usage(void)
{
   printf(
      "Usage: %s [-hvDVmuxrfl] [-s Hz] [-b 8|16] [-B kilobytes] [filename]\n",
	    info.progname);
   fputs("\
\n\
  -h, --help              print this help, then exit\n\
  -v, --version           print version, then exit\n\
  -V, --verbose           print useful information\n\
  -x, --swap              swap endianness\n\
  -m, --mono              mono sample\n\
  -u, --usage             print buffer usage while playing\n\
  -r, --raw               force raw audio format\n\
  -f, --force             force playing with any parameters\n\
  -s, --speed=SPEED       sampling rate (Hz)\n\
  -b, --bits=BITS         bits per sample (8 or 16)\n\
  -B, --buffer-size=SIZE  buffer size in kilobytes or seconds\n\
  -D, --device=DEVICE     device name\n\
  -l, --loop              loop the sample\n", stdout);
   exit(1);
}

void warning(char *str)
{
   fprintf(stderr, "%s: Warning: %s\n", info.progname, str);
}

void warning2(char *str1, char *str2)
{
   fprintf(stderr, "%s: Warning: %s: %s\n", info.progname, str1, str2);
}

void die(char *str)
{
   fprintf(stderr, "%s: %s\n", info.progname, str);
   destroy_buffer();
   close_audio();
   exit(-1);
}

void errdie(char *str)
{
   fprintf(stderr, "%s: Error: %s\n", info.progname, str);
   destroy_buffer();
   close_audio();
   exit(-1);
}

void open_file(char *file)
{
   close_file();
   if ((info.file_fd = open(file, O_RDONLY)) == -1)
      errdie("Opening audio file failed");
}

void close_file(void)
{
   if ((info.file_fd != -1) && (info.file_fd != STDIN_FILENO)) {
      close(info.file_fd);
      info.file_fd = -1;
   }
}

void destroy_buffer(void)
{
   /* Free memory */
   if (info.buffer != NULL)
      Efree(info.buffer);
}

/* Write only readable characters to fp */
void nice_fputc(int c, FILE * fp)
{
   if ((c >= 32) && (c <= 127))
      putc(c, fp);
   else
      putc((int) ' ', fp);
}
