/* Extended Module Player - pru1_load.c
 * Copyright (C) 1996-1998 Claudio Matsuoka and Hipolito Carraro Jr
 *
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See doc/COPYING
 * for more information.
 */

/* Loader for ProRunner 1.0 modules based on the format description
 * written by Sylvain Chipaux (Asle/ReDoX). Modules sent by Bert
 * Jahn.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "load.h"
#include "period.h"
#include "include/mod.h"

int pru1_load(FILE * f)
{
   int i, j, k;
   struct xxm_event *event;
   struct m31_header ph;
   uint8 pe[4];

   LOAD_INIT();

   xxh->tpo = 6;
   xxh->bpm = 125;
   xxh->ins = 31;
   xxh->smp = xxh->ins;
   xxh->chn = 4;

   fread(&ph, 1, sizeof(struct m31_header), f);

   if (ph.magic[0] != 'S' || ph.magic[1] != 'N' || ph.magic[2] != 'T' ||
       ph.magic[3] != '.')
      return -1;

   strncpy(module_name, (char *) ph.name, 20);
   sprintf(module_type, "ProRunner v1");

   MODULE_INFO();

   xxh->len = ph.len;

   for (xxh->pat = i = 0; i < xxh->len; i++) {
      xxo[i] = ph.order[i];
      if (xxo[i] > xxh->pat)
	 xxh->pat = xxo[i];
   }
   xxh->pat++;

   xxh->trk = xxh->pat * xxh->chn;

   INSTRUMENT_INIT();

   for (i = 0; i < xxh->ins; i++) {
      B_ENDIAN16(ph.ins[i].size);
      B_ENDIAN16(ph.ins[i].loop_start);
      B_ENDIAN16(ph.ins[i].loop_size);
      xxi[i] = Ecalloc(sizeof(struct xxm_instrument), 1);

      xxs[i].len = 2 * ph.ins[i].size;
      xxs[i].lps = 2 * ph.ins[i].loop_start;
      xxs[i].lpe = xxs[i].lps + 2 * ph.ins[i].loop_size;
      xxs[i].flg = ph.ins[i].loop_size > 1 ? WAVE_LOOPING : 0;
      xxi[i][0].fin = (int8) ph.ins[i].finetune << 4;
      xxi[i][0].vol = ph.ins[i].volume;
      xxi[i][0].pan = 0x80;
      xxi[i][0].sid = i;
      xxih[i].nsm = !!(xxs[i].len);
      xxih[i].rls = 0xfff;
      strncpy((char *) xxih[i].name, (char *) ph.ins[i].name, 22);

      if (opt.verbose > 1 && (strlen((char *) xxih[i].name) || xxs[i].len > 2)) {
	 report("[%2X] %-22.22s %04x %04x %04x %c V%02x %+d\n",
		i, xxih[i].name, xxs[i].len, xxs[i].lps,
		xxs[i].lpe, ph.ins[i].loop_size > 1 ? 'L' : ' ',
		xxi[i][0].vol, (char) xxi[i][0].fin >> 4);
      }
   }

   PATTERN_INIT();

   /* Load and convert patterns */
   if (opt.verbose)
      report("Stored patterns: %d ", xxh->pat);

   for (i = 0; i < xxh->pat; i++) {
      PATTERN_ALLOC(i);
      xxp[i]->rows = 64;
      TRACK_ALLOC(i);
      for (j = 0; j < 64; j++) {
	 for (k = 0; k < 4; k++) {
	    event = &EVENT(i, k, j);
	    fread(pe, 4, 1, f);

	    /* event format:

	     * 0000 0000  0000 0000  0000 0000  0000 0000
	     * \       /  \       /       \  /  \       /
	     *   inst       note           fx     fxval
	     */

	    if ((event->note = pe[1]) != 0)
	       event->note += 36;
	    event->ins = pe[0];
	    event->fxt = LSN(pe[2]);
	    event->fxp = pe[3];

	    if (!event->fxp) {
	       switch (event->fxt) {
	       case 0x05:
		  event->fxt = 0x03;
		  break;
	       case 0x06:
		  event->fxt = 0x04;
		  break;
	       case 0x01:
	       case 0x02:
	       case 0x0a:
		  event->fxt = 0x00;
	       case 0x0f:
		  break;
	       }
	    }
	 }
      }

      if (opt.verbose)
	 report(".");
   }

   if (opt.modrange)
      xxh->flg |= XXM_FLG_MODRNG;
   if (opt.ntsc) {
      opt.rrate = NTSC_RATE;
      opt.c4rate = C4_NTSC_RATE;
   }

   /* Load samples */

   if (opt.verbose)
      report("\nStored samples : %d ", xxh->smp);
   for (i = 0; i < xxh->smp; i++) {
      if (!xxs[i].len)
	 continue;
      drv_loadpatch(f, xxi[i][0].sid, opt.c4rate, 0,
		    &xxs[xxi[i][0].sid], NULL);
      if (opt.verbose)
	 report(".");
   }
   if (opt.verbose)
      report("\n");

   for (i = 0; i < xxh->chn; i++)
      xxc[i].pan = (((i + 1) / 2) % 2) * 0xff;

   return 0;
}
