
/* Extended Module Player - readrc.c
 * Copyright (C) 1996-1998 Claudio Matsuoka and Hipolito Carraro Jr
 *
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See doc/COPYING
 * for more information.
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "xmp.h"

static int smp8bit;
static int interpolate;
static int verbose;
static int loop;
static int modrange;
static int mix = 75;
static int freq = 22050;
static int ttime;
static int res8bit;
static int reverse = 1;
static int nopan;

static int get_yesno(char *s)
{
   return !(strncmp(s, "y", 1) && strncmp(s, "o", 1));
}


int xmpi_read_rc(struct xmp_options *opt)
{
   opt->smp8bit = smp8bit;
   opt->interpolate = interpolate;
   opt->loop = loop;
   opt->modrange = modrange;
   opt->mix = mix;
   opt->freq = freq;
   opt->time = ttime;
   opt->verbose = verbose;
   opt->res8bit = res8bit;
   opt->reverse = reverse;
   opt->nopan = nopan;
   return 0;
}

void xmp_config(char *var, char *val)
{
#define getval_yn(x,y) { \
        if (!strcmp(var,x)) { y = get_yesno (val); return; } }

#define getval_no(x,y) { \
        if (!strcmp(var,x)) { y = atoi (val); return; } }

   getval_yn("8BIT", smp8bit);
   getval_yn("INTERPOLATE", interpolate);
   getval_yn("LOOP", loop);
   getval_yn("MODRANGE", modrange);
   getval_no("MIX", mix);
   getval_no("SRATE", freq);
   getval_no("TIME", ttime);
   getval_no("VERBOSITY", verbose);

   if (!strcmp(var, "BITS")) {
      res8bit = (atoi(val) == 8);
      return;
   }
   if (!strcmp(var, "REVERSE")) {
      if (get_yesno(val))
	 reverse = -1;
      return;
   }
   if (!strcmp(var, "PAN")) {
      nopan = !get_yesno(val);
      return;
   }
   if (!strcmp(var, "MONO")) {
      reverse *= !get_yesno(val);
      return;
   }
}
