/*
 * gom_iface_c.c: command line interface
 */

/* 
 * This file is part of the package
 *
 * gom, Gom is nOt yet another Mixer
 *
 * (c) Stephan Suerken <suerken@fh-worms.de> 1996, 1997
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * INCLUDES
 */
#include "gom.h"

/*
 * MACROS
 */

/*
 * DECLARATIONS/DEFINTIONS
 */

/*
 * FUNCTION PROTOTYPES
 */

/*****************/

/*
 * COMMAND LINE INTERFACE
 */

char *
gom_iface_c_get_option_args(char * prompt)
{
  return optarg;
}

int
gom_iface_c_question(char * question)
{
  char answer;
  gom_info(GOM_INFO_QUIET, "%s %s ", "[y|Y = yes, else no]", question);
  scanf("%c", &answer);
  return (toupper(answer) == 'Y');
}


void
gom_iface_c_config_check()
{
  int pre_errors;

  /* CHECKING USER CONFIGURATION */
  pre_errors = gom_info_errors;
  gom_info(GOM_INFO_QUIET, "Checking configuration...", gom_file_fn);
  gom_info(GOM_INFO_QUIET, "---");
  gom_file_config_load (GOM_INFO_NORMAL, -1);
  gom_info(GOM_INFO_QUIET, "---");
  gom_info(GOM_INFO_QUIET, "%i errors detected while checking configuration.", gom_info_errors - pre_errors);
  gom_info(GOM_INFO_QUIET, "");
  
  if (pre_errors < gom_info_errors)
    {
      gom_info_block(GOM_INFO_QUIET, 2,
		     "There have been errors checking the configuration. If you want more "
		     "diagnostic output, please load the config file in question with a "
		     "increased verbosity level (e.g. \"gom --verbose --get-options=gomrc\").");
      gom_info_block(GOM_INFO_QUIET, 2,
		     "Please note: gom loads _either_ the user's (~/" GOM_CONFIG_DIR_USER GOM_CONFIG_FILE ") "
		     "or the system's configuration file (" GOM_CONFIG_DIR_SYSTEM GOM_CONFIG_FILE "). The "
		     "latter is used only if the user config does not exist; if both do not exist, then "
		     "there is no configuration for gom -- which is perfectly normal. To correct "
		     "errors, please create and/or change your user's config file.");
    }
}


void 
gom_iface_c(int argc, char *argv[])
{
  char action = 0;

  /* the command line interface uses the default */
  gom_info_custom_set(NULL);

  if (argc == 1)
    {
      /* called with no options */
      gom_info(GOM_INFO_QUIET, "");
      gom_info_block(GOM_INFO_QUIET, 2,
		     "No options given! For normal use, I must be invoked with arguments. "
		     GOM_ACTION_HELPHINT);

      gom_info(GOM_INFO_QUIET, "");
      gom_iface_c_config_check();
    }
  else
    {
      /* read very first argument */
      action = gom_action_getopt(argc, argv);
      /* load the config file, probably skipping device loading */
      gom_file_config_load (GOM_INFO_VERBOSE, action == 'd' ? 'd' : -1);

      /* now continue as if nothing happened; if the very first arg was really 'd', */
      /* it will be loaded in the very first loop */

      while (action != EOF)
	{
	  gom_action(GOM_INFO_NORMAL, action, 1, gom_iface_c_get_option_args, NULL, NULL);
	  action = gom_action_getopt(argc, argv);
	}
    }
}
