//
//  Mixer.app
// 
//  Copyright (c) 1998 Per Liden
// 
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
//  USA.
//

#ifndef _Mixer_h_
#define _Mixer_h_

#include <X11/Xlib.h>
#include <iostream.h>
#include <getopt.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <linux/soundcard.h>
#include "Xpm.h"


#define VERSION		"1.0.5"
#define APPNAME		"Mixer.app"
#define DEVICE		"/dev/mixer"
#define TIMERINTERVAL	50000
#define LED_X		7
#define LED_Y		5
#define BUTTON_MIN	17
#define BUTTON_MAX	48


class Mixer
{
public:
    friend void VolumeUpdate(int dummy);

    Mixer(int argc, char** argv);
    ~Mixer();
    void Run();

private:
    Mixer();	// Disabled constructor
    void ShowErrorLed();    
    void SetTimer(int interval);
    void GetVolume();
    void SetVolume(int button, int volume);

    int Error;
    Window AppWin;
    Window IconWin;
    Window Button[3];

    int VolumeDevice[3];
    int VolumeOld[3];
    int Volume[3];
};


#endif

