// fileselector.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FileSelector is a FileChooser (InterViews class) which contains a
// QueryValue as a member.  The QueryValue initially contains the directory
// to being the file search, and ends up containing the name of the file to be
// opened.  A FileSelector instance is a member of the FileDialog class (see
// dialog.h).

#ifndef FILESELECTOR_H
#ifdef __GNUG__
#pragma interface
#endif
#define FILESELECTOR_H

#include <InterViews/filechooser.h>
#include "localdefs.h"

class ButtonState;
class QueryValue;
class Event;
class EventForwarder;

class FileSelector : public FileChooser {
	typedef FileChooser Super;
	friend class DialogConstructor;
public:
	static boolean showDotFiles() { return show_DotFiles; }
	static void showDotFiles(boolean b) { show_DotFiles = b; }
public:
	FileSelector(ButtonState *, QueryValue *path,
		const char* suffixes, int rows, int cols);
	virtual ~FileSelector();
	redefined boolean Accept();
	boolean setValue();
protected:
	void setForwarder(EventForwarder* ef);
	QueryValue* value() { return myValue; }
	boolean doAccept();
private:
	static boolean show_DotFiles;
private:
	void initialize(const char*);
	Interactor* createInterior();
	static void storeDirectory(const char*);
	static const char* retrieveDirectory();
	QueryValue* myValue;
	EventForwarder* forwarder;
	static char savedDir[];
};

#endif
