/*******************************************************************/
/*                                                                 */
/* (C) Klangatelier Algorythmics                                   */
/*******************************************************************/
/* Defines */
/* Makros */
/* --------------------------------------------------------------- */
/* Typendefinition.                                                */
/* --------------------------------------------------------------- */
#ifndef MIDIFILE_H
#define MIDIFILE_H

/* a) allgemein */
#ifndef MIDI_H
#include "mididefs.h"
#endif

/* b) midifile */

typedef struct _MTevt{
  unsigned long dt;	      /* deltatime */
  MIDIevt data;
  struct _MTevt *next;
  struct _MTevt *prev;
} MTevt;


/* MIDI Track */
typedef struct _MTrk{
  char *type;   /*  Immer "MTrk" */
  unsigned long length;  /* variabel: Zahl der Bytes */
  MTevt *events;
  struct _MTrk *next; /* naechste oder 0l */
} MTrk;


/* MIDI Header */
typedef struct{
  char *type;       /* Immer "MThd" */
  unsigned long length;	     /* immer 6 */
  int format;       /* Format: 0,1,2 */
  int ntrks;        /* Trackanzahl */
  int divisions;    /* Time byte 16 Bit */
  MTrk *starttrack; /* erste Track */
} MThd;


/* MIDI File */
typedef struct {
  char *name;    /* filename */
  MThd *MThd;
} MIDIFile;


/* -------------------------------------------------------------------- */
/*    Defnines                                                          */
/* -------------------------------------------------------------------- */
/* MIDI event */
#define MF_META_EVENT  0xFF
#define MF_SYSEX_EVENT 0xF0
#define MF_ESC_EVENT   0xF7

/* Meta events */
#define MF_META_SEQNR    0x00
#define MF_META_TEXT     0x01
#define MF_META_CPRGHT   0x02
#define MF_META_TRKNAME  0x03
#define MF_META_INSTNAME 0x04
#define MF_META_LYRIC    0x05
#define MF_META_MARKER   0x06
#define MF_META_CUEPOINT 0x07
#define MF_META_MIDICHAN 0x20
#define MF_META_ENDOFTRK 0x2F
#define MF_META_SETTEMPO 0x51
#define MF_META_SMPTEOFF 0x54
#define MF_META_TIMESIGN 0x58
#define MF_META_KEYSIGN  0x59
#define MF_META_SEQSPEC  0x7F

/* DEFINE verbose-modes 0,1,2,3*/
#define MF_VERB_NO    0
#define MF_VERB_ERROR 1 /* only errors on stderr */
#define MF_VERB_OK    2 /* sucess on tracks */
#define MF_VERB_DEBUG 3 /* every event */

/* max long (64 bit) is 2 fach 0xFFFFFFFF ... 87 FF FF FF 7F ... 2*5 bytes */ 
#define MF_MAX_VARNUM_LEN 10
/* -------------------------------------------------------------------- */
/*    Funktionsprototypen.                                              */
/* -------------------------------------------------------------------- */

/* read midifile and store in memory */
MIDIFile *mf_read(char *filename); 
/* free memory */
void mf_free(MIDIFile *mifi);

/* print in ascii format for debug */
void mf_print(MIDIFile *mifi);
void mf_print_meta(METAstr *meta);
void mf_print_sysex(MIDIstr *sysex);
void mf_print_escape(MIDIstr *sysex);
void mf_print_midi(MIDIevt *evt);

/* HELPS: */
unsigned long mf_varnum_to_int(byte *data); /* read variable-length number */
int mf_int_to_varnum(byte *v,unsigned long num); /* make variable len number */

int mf_copy_varnum(byte *dest,const byte *src);

int mf_verbose(int i);

/* -------------------------------------------------------------------- */
/*       Extern definierte globale Variable.                            */
/* -------------------------------------------------------------------- */
#endif
