/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net               *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/ioctl.h>
#ifdef __NetBSD__
  #include <soundcard.h>
#endif
#ifdef __FreeBSD__
  #include <machine/soundcard.h>
#endif
#ifdef __linux__
  #include <linux/soundcard.h>
#endif
#include "sound.h"

int sPlayFile(char *sound_file, char *audiodev) {
  int snd_typ = 0;
  
  if(!sound_file) {
    printf("Could not find sound '%s'",sound_file);
  }
  snd_typ = Find_SndFmt(sound_file);
  switch(snd_typ) {
    case 1: {return(sCoreAu(sound_file,audiodev));}
    case 2: {return(sCoreRiff(sound_file,audiodev));}
    default: {return(ERR_UNSUPPORTED);}
  }
}

int goto_chunk(FILE *instream, int chunk) {
  int indexCount = 0,found_tag = -1;
  unsigned char bit_op[5];
  switch (chunk) {
    case format_chunk:
    {				
      do
      {
	if(indexCount > 1000) {
          /* Get out if we have not found the WAVfmt  tag after 1000 bytes */						
	  break;
	}					
	fread(&bit_op,sizeof(bit_op)-1,1,instream);
	bit_op[4] = '\0';
	found_tag = strcmp(bit_op,"fmt ");
	indexCount++;
      }while(found_tag != 0);
      if(found_tag  != 0) {
        return -1;
      }
      return found_tag;
    }
    case data_chunk:
    {
      do
      {
        if(indexCount > 1000) {
          /* Get out if we have not found the data tag after 1000 bytes */						
	  break;
	} 
	fread(&bit_op,sizeof(bit_op)-1,1,instream);
	bit_op[4] = '\0';
	found_tag = strcmp(bit_op,"data");
	if(found_tag != 0) {
	  bit_op[3]  = '\0';
	  found_tag = strcmp(bit_op,"ata");
	  if(found_tag == 0) {
	    /*reset the file in order to get the datalen correct*/
	    fseek(instream,-1L,SEEK_CUR);
	  } 
	  else {
	    bit_op[2]  = '\0';
	    found_tag = strcmp(bit_op,"ta");
	    if(found_tag == 0) {
              /*reset the file in order to get the datalen correct*/
	      fseek(instream,-2L,SEEK_CUR); 
	    } 
	  }
        }
        indexCount++;
      }while(found_tag != 0);
      if(found_tag  != 0) {
        return -1;
      }
      return found_tag;
    } 
  }
  return -1;
}
int sCoreAu(char *sound_file, char *audiodev) {
  FILE *fstream;
  int audiofd = 0, wrbytes, index, work_int, chk_st = 0;
  dword datalen = 0, work_ulong, hdrincr = 0;
  unsigned char *inbuff; 	
  struct stat flstat;
  au_info auheader;
  
  chk_st = stat(sound_file, &flstat);
  if (chk_st > 0) {
    return ERR_ONSTAT;
  }
  
  fstream = fopen(sound_file,"rb");
  if(!fstream) {
    return ERR_NOFSTREAM;
  }
  auheader.magic = Read_BE_DWORD(fstream);
  auheader.hdr_size = Read_BE_DWORD(fstream);
  auheader.data_size = Read_BE_DWORD(fstream);
  auheader.encoding = Read_BE_DWORD(fstream);
  auheader.sample_rate = Read_BE_DWORD(fstream);
  auheader.channels = Read_BE_DWORD(fstream);
  if (auheader.hdr_size > 24) {
    hdrincr = Read_BE_DWORD(fstream);
    hdrincr = Read_BE_DWORD(fstream);
  }
  datalen = (dword)flstat.st_size - auheader.hdr_size;

  audiofd = open(audiodev, O_WRONLY,0);
  if (audiofd == -1) {
    fclose(fstream);
    return NO_SOUND_DEV;
  }

  work_int = auheader.encoding;
  if (ioctl(audiofd,SNDCTL_DSP_SETFMT,&work_int) < 0) {
    fclose(fstream);
    close(audiofd);
    return ERR_DSP_SETFMT;
  }
  if(auheader.channels > 1) {
    work_int = 1;
  }
  else {
    work_int = 0;
  }
  if (ioctl(audiofd,SNDCTL_DSP_STEREO,&work_int) < 0) {
    fclose(fstream);
    close(audiofd);
    return ERR_DSP_STEREO;
  }
  work_ulong = auheader.sample_rate;
  if (ioctl(audiofd,SNDCTL_DSP_SPEED,&work_ulong) < 0) {
    fclose(fstream);
    close(audiofd);
    return ERR_DSP_SPEED;
  }
  if (ioctl(audiofd,SNDCTL_DSP_SYNC,NULL) < 0) {
    /* Do nothing for now */
  }
  
  if(datalen > 4096) {
    wrbytes = 4096;
  }
  else {
    wrbytes = datalen;
  }
  while(datalen > 0) {
    if(wrbytes > datalen) {
      wrbytes = datalen;
    }
    inbuff = (unsigned char *)malloc(wrbytes);
    if(!inbuff) {
      fclose(fstream);
      close(audiofd);
      return NO_MEMORY;
    }
    if((index = fread(inbuff,wrbytes,1,fstream)) < 1) {
      free(inbuff);
      fclose(fstream);
      close(audiofd);
      return ERR_READ_DATA;
    }
    if(write(audiofd,inbuff,wrbytes) != wrbytes) {
      free(inbuff);
      fclose(fstream);
      close(audiofd);
      return ERR_WRITE_DATA;
    }
    datalen -= (unsigned long) wrbytes;
    free(inbuff);
    inbuff = 0;
  }
  fclose(fstream);
  close(audiofd);
  return 0;
  
}

int sCoreRiff(char *sound_file, char *audiodev){
  FILE *fstream;
  int audiofd = 0, wrbytes, index, work_int;
  dword datalen = 0, work_ulong;
  unsigned char *inbuff; 	
  riff_info riffheader;
  wavheader headerinfo;
  
  fstream = fopen(sound_file,"rb");
  if(!fstream) {
    return ERR_NOFSTREAM;
  }
  fread(&riffheader.riff,sizeof(riffheader.riff),1,fstream);
  riffheader.riffsize = Read_LE_DWORD(fstream);
  riffheader.riff[3] = '\0';
  if(goto_chunk(fstream,format_chunk) != 0) {
    fclose(fstream);
    return ERR_FORMAT_TAG;
  }
  headerinfo.pcmheader = Read_LE_DWORD(fstream);
  headerinfo.pcmfmt = Read_LE_WORD(fstream);
  headerinfo.channels = Read_LE_WORD(fstream);
  headerinfo.sampleps = Read_LE_DWORD(fstream);
  headerinfo.bytesps = Read_LE_DWORD(fstream);
  headerinfo.bytespsamp = Read_LE_WORD(fstream);
  headerinfo.bitsperchan = Read_LE_WORD(fstream);

  if(headerinfo.bitsperchan != 16){
    if(headerinfo.bitsperchan != 8) {
      fclose(fstream);
      return ERR_UNSUPPORTED;
    }
  }

  if(goto_chunk(fstream,data_chunk) != 0) {
    fclose(fstream);
    return ERR_DATA_TAG;
  }
  datalen = Read_LE_DWORD(fstream);

  audiofd = open(audiodev, O_WRONLY,0);
  if (audiofd == -1) {
    fclose(fstream);
    return NO_SOUND_DEV;
  }

  work_int = headerinfo.bitsperchan;
  if (ioctl(audiofd,SNDCTL_DSP_SETFMT,&work_int) < 0) {
    fclose(fstream);
    close(audiofd);
    return ERR_DSP_SETFMT;
  }
  if(headerinfo.channels > 1) {
    work_int = 1;
  }
  else {
    work_int = 0;
  }
  if (ioctl(audiofd,SNDCTL_DSP_STEREO,&work_int) < 0) {
    fclose(fstream);
    close(audiofd);
    return ERR_DSP_STEREO;
  }
  work_ulong = headerinfo.sampleps;
  if (ioctl(audiofd,SNDCTL_DSP_SPEED,&work_ulong) < 0) {
    fclose(fstream);
    close(audiofd);
    return ERR_DSP_SPEED;
  }
  if (ioctl(audiofd,SNDCTL_DSP_SYNC,NULL) < 0) {
    /* Do nothing for now */
  }
  
  if(datalen > 4096) {
    wrbytes = 4096;
  }
  else {
    wrbytes = datalen;
  }
  while(datalen > 0) {
    if(wrbytes > datalen) {
      wrbytes = datalen;
    }
    inbuff = (unsigned char *)malloc(wrbytes);
    if(!inbuff) {
      fclose(fstream);
      close(audiofd);
      return NO_MEMORY;
    }
    if((index = fread(inbuff,wrbytes,1,fstream)) < 1) {
      free(inbuff);
      fclose(fstream);
      close(audiofd);
      return ERR_READ_DATA;
    }
    if(write(audiofd,inbuff,wrbytes) != wrbytes) {
      free(inbuff);
      fclose(fstream);
      close(audiofd);
      return ERR_WRITE_DATA;
    }
    datalen -= (unsigned long) wrbytes;
    free(inbuff);
    inbuff = 0;
  }
  fclose(fstream);
  close(audiofd);
  return 0;

}

int sCoreDumpAu(char *sound_file) {
  FILE *fstream;
  au_info auheader;
  
  fstream = fopen(sound_file,"rb");
  if(!fstream) {
    return ERR_NOFSTREAM;
  }
  auheader.magic = Read_BE_DWORD(fstream);
  auheader.hdr_size = Read_BE_DWORD(fstream);
  auheader.data_size = Read_BE_DWORD(fstream);
  auheader.encoding = Read_BE_DWORD(fstream);
  auheader.sample_rate = Read_BE_DWORD(fstream);
  auheader.channels = Read_BE_DWORD(fstream);

  printf("-----Begin AU file tag dump ------\n");
  printf("\n");
  printf("AU magic        : %d\n", auheader.magic);
  printf("AU header size  : %d\n", auheader.hdr_size);
  printf("AU data size    : %d\n", auheader.data_size);
  printf("AU encoding     : %d\n", auheader.encoding);
  printf("AU sample rate  : %d\n", auheader.sample_rate);
  printf("AU channels     : %d\n", auheader.channels);
  printf("\n");
  printf("-----End of AU file tag dump ------\n");
  return 0;

}

int sCoreDumpWav(char *sound_file){
  FILE *fstream;
  dword datalen = 0;
  riff_info riffheader;
  wavheader headerinfo;
  
  fstream = fopen(sound_file,"rb");
  if(!fstream) {
    return ERR_NOFSTREAM;
  }
  fread(&riffheader.riff,sizeof(riffheader.riff),1,fstream);
  riffheader.riffsize = Read_LE_DWORD(fstream);
  riffheader.riff[3] = '\0';
  if(goto_chunk(fstream,format_chunk) != 0) {
    fclose(fstream);
    return ERR_FORMAT_TAG;
  }
  headerinfo.pcmheader = Read_LE_DWORD(fstream);
  headerinfo.pcmfmt = Read_LE_WORD(fstream);
  headerinfo.channels = Read_LE_WORD(fstream);
  headerinfo.sampleps = Read_LE_DWORD(fstream);
  headerinfo.bytesps = Read_LE_DWORD(fstream);
  headerinfo.bytespsamp = Read_LE_WORD(fstream);
  headerinfo.bitsperchan = Read_LE_WORD(fstream);

  if(goto_chunk(fstream,data_chunk) != 0) {
    fclose(fstream);
    return ERR_DATA_TAG;
  }
  datalen = Read_LE_DWORD(fstream);

  printf("-----Begin Wav file tag dump ------\n");
  printf("\n");
  printf("Riff Header info      : %s\n", riffheader.riff);
  printf("Riff Size with header : %d\n", riffheader.riffsize);
  printf("PCM Header info       : %d\n", headerinfo.pcmheader);
  printf("PCM Format info       : %d\n", headerinfo.pcmfmt);
  printf("PCM Channels info     : %d\n", headerinfo.channels);
  printf("PCM Samples Per Sec   : %d\n", headerinfo.sampleps);
  printf("PCM Bytes Per Sec     : %d\n", headerinfo.bytesps);
  printf("PCM Bytes Per Samp    : %d\n", headerinfo.bytespsamp);
  printf("PCM Bits Per Channel  : %d\n", headerinfo.bitsperchan);
  printf("Total data size       : %d\n", datalen);
  printf("\n");
  printf("-----End of Wav file tag dump ------\n");
  return 0;
}

/* Begin utils section */
dword Read_LE_DWORD(FILE *fstream)
{
  dword retVal;
  
  retVal  = fgetc(fstream);
  retVal |= fgetc(fstream) << 8;
  retVal |= fgetc(fstream) << 16;
  retVal |= fgetc(fstream) << 24;
  return retVal;
}

word Read_LE_WORD(FILE *fstream)
{
  word retVal;
  retVal = fgetc(fstream);
  retVal |= fgetc(fstream) << 8;
  return retVal;
}

dword Read_BE_DWORD(FILE *fstream)
{
  dword retVal;
  
  retVal  = fgetc(fstream) << 24;
  retVal |= fgetc(fstream) << 16;
  retVal |= fgetc(fstream) << 8;
  retVal |= fgetc(fstream);
  return retVal;
}

word Read_BE_WORD(FILE *fstream)
{
  word retVal;
  retVal = fgetc(fstream) << 8;
  retVal |= fgetc(fstream);
  return retVal;
}

int Find_SndFmt(char *sound_file) {
  FILE *fstream;
  dword chkhdr;

  fstream = fopen(sound_file,"rb");
  if(!fstream) {
    return ERR_NOFSTREAM;
  }
  fread(&chkhdr,sizeof(chkhdr),1,fstream);  
  fclose(fstream);
  if (chkhdr == 1684960046) {
    return 1;
  }
  if (chkhdr == 1179011410) {
    return 2;
  }
  return -1;
}