/******************************************************************************
*   NMaker	NoiseMaker Command Line tool for playing sounds               *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net               *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/
#include "nmaker.h"


int main(int argc, char *argv[]) {
  int retCode = 0;
  proplist_t prop, key,val;
  char *devAudio;
  char *path;

  if((!argv[1]) || (strstr(argv[1], "-h"))) {
    printf("%s\n", usage);
    exit(1);
  }
  else {
    path = defaultsPathForDomain(CFG_DOMAIN);    
    prop = PLGetProplistWithPath(path);
    if(!prop) {
      printf("%s:could not load WindowMaker configuration file '%s'\n",argv[0],path);
      exit(1);
    }
    if (find_SoundServer() <= 0) {
      key = PLMakeString("Device");
      val = PLGetDictionaryEntry(prop,key);
      devAudio = PLGetString(val);
      retCode = sPlayFile(argv[1], devAudio);
      PLRelease(key);
      PLRelease(val);
      PLRelease(prop);
      if(devAudio) { free(devAudio);}
      if(path) {free(path);}
      return retCode;
    }
    else {
      key = PLMakeString(options);
      val = PLMakeString(argv[1]);
      PLRemoveDictionaryEntry(prop,key);
      PLInsertDictionaryEntry(prop,key,val);
      PLSave(prop,YES);
      nmSendSound();
      PLRelease(key);
      PLRelease(val);
      PLRelease(prop);
      if(path) {free(path);}
    }
  }
  return 0;
}

int find_SoundServer()
{
  Window *lstChildren;
  Window retRoot;
  Window retParent;
  int indexCount;
  u_int numChildren;
  XClassHint *retHint; 
  
  dpy = XOpenDisplay("");
  if(!dpy) {
    return -1;
  }
  _XA_WINDOWMAKER_WM_FUNCTION = XInternAtom(dpy,"_WINDOWMAKER_WM_FUNCTION",False);    
  if(XQueryTree(dpy,DefaultRootWindow(dpy),&retRoot, &retParent,&lstChildren,&numChildren)) {
    for(indexCount = 1;indexCount < numChildren;indexCount++)
    {
      retHint = XAllocClassHint();
      if(!retHint) {
        XFree(lstChildren);
        printf("No Memory\n");
        return -1;
      }
      XGetClassHint(dpy,lstChildren[indexCount],retHint);
      if(retHint->res_class){
        if (strcmp("WMSoundServer",retHint->res_class) == 0) {
          wmsnd = lstChildren[indexCount];
          XFree(lstChildren);
          if(retHint) { XFree(retHint);}
          return 1;
        }
      }
      XFree(retHint);
      retHint = 0;
    }  
    XFree(lstChildren);
  }
  XCloseDisplay(dpy);
  return 0;
}

char* defaultsPathForDomain(char *domain)
{
    char path[1024];
    char *gspath, *tmp;

    gspath = getenv("GNUSTEP_USER_ROOT");
    if (gspath) {
	strcpy(path, gspath);
	strcat(path, "/");
    } else {
	char *home;
	
	home = getenv("HOME");
	if (!home) {
	    printf("could not get HOME environment variable!\n");
	    exit(0);
	}
	strcpy(path, home);
	strcat(path, "/GNUstep/");
    }
    strcat(path, DEFAULTS_DIR);
    strcat(path, "/");
    strcat(path, domain);

    tmp = malloc(strlen(path)+2);
    strcpy(tmp, path);
    return tmp;
}

int nmSendSound() {
  XEvent SoundEvent;
  
  SoundEvent.xclient.type = ClientMessage;
  SoundEvent.xclient.message_type = _XA_WINDOWMAKER_WM_FUNCTION; 
  SoundEvent.xclient.format = 32;
  SoundEvent.xclient.display = dpy;
  SoundEvent.xclient.window = wmsnd;
  SoundEvent.xclient.data.l[0] = 1011;
  XSendEvent(dpy,wmsnd,False,NoEventMask,&SoundEvent);
  XFlush(dpy);
  return 0;
}