/******************************************************************************
*   WMSound Setup       for WindowMaker Sound Server            [Version 0.7] *
*   Copyright (C) 1998  Pascal Hofstee <daeron@shadowmere.student.utwente.nl> *
*                                                                             *
*   WindowMaker Sound Server                                                  *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net>              *
*                       William Moore <billy@mud.mind.net>                    *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/

#include <WINGs.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <proplist.h>

#include "wsconfig.h"
#include "wmss.h"


extern Display	*dpy;

static void
addSoundPath(WMButton *bPtr, WMSSSoundPathPanel *parentpanel)
{
    WMOpenPanel	*panel;

    panel = WMGetOpenPanel(WMWidgetScreen(bPtr));

    WMSetFilePanelCanChooseDirectories(panel, 1);
    WMSetFilePanelCanChooseFiles(panel, 0);
    if (WMRunModalOpenPanelForDirectory(panel, "/", NULL, NULL)) {
      char *result;
      result = WMGetFilePanelFile(panel);

      if (chdir(result)==0) {
        WMAddListItem(parentpanel->soundpathList, result);
        WMSetLabelText(parentpanel->soundpathStatusLabel, "Added Directory to SoundPath");
      }
      else {
        WMSetLabelText(parentpanel->soundpathStatusLabel, "Not a Directory");
      }
      free(result);
    }                 
    WMFreeFilePanel(panel);
}

static void
removeSoundPath(WMButton *bPtr, WMSSSoundPathPanel *parentpanel)
{
    int elem;
    WMListItem *selected;

    selected = WMGetListSelectedItem(parentpanel->soundpathList);
    
    elem = WMGetListSelectedItemRow(parentpanel->soundpathList);
    WMRemoveListItem(parentpanel->soundpathList, elem);
}


static void
wmssSoundPathButtonClick(WMButton *bPtr, WMSSSoundPathPanel *panel)          
{
    if (bPtr == panel->okButton) 
        panel->flags.canceled = 0;
    else                                   
        panel->flags.canceled = 1;

    panel->flags.done = 1;
}

WMSSSoundPathPanel*
wmssCreateSoundPathPanel(WMScreen *scrPtr, char **soundpath)
{
    WMSSSoundPathPanel	*panel;
    int elem;

    panel = malloc(sizeof(WMSSSoundPathPanel));
    memset(panel, 0, sizeof(WMSSSoundPathPanel));

    /*
    --------------------------
    The Actual SoundPath Panel
    --------------------------
    */
    panel->win = WMCreateWindow(scrPtr, "soundpathPanel");
    WMSetWindowTitle(panel->win, "WMSound SoundPath");
    WMResizeWidget(panel->win, 340,176);


    /*
    -----------------
    SoundPath ListBox
    -----------------
    */
    panel->soundpathList = WMCreateList(panel->win);
    WMResizeWidget(panel->soundpathList, 324, 100);
    WMMoveWidget(panel->soundpathList, 8, 8);

    for (elem = 0; soundpath[elem] != NULL; elem++) {
      WMAddListItem(panel->soundpathList, soundpath[elem]);
    }




    /*
    --------------------
    SoundPath Status Bar
    --------------------
    */
    panel->soundpathStatusLabel = WMCreateLabel(panel->win);
    WMResizeWidget(panel->soundpathStatusLabel, 324, 20);
    WMMoveWidget(panel->soundpathStatusLabel, 8, 116);
    WMSetLabelText(panel->soundpathStatusLabel, "Ready ...");                           
    WMSetLabelRelief(panel->soundpathStatusLabel, WRSunken);                            
    WMSetLabelTextAlignment(panel->soundpathStatusLabel, WALeft);                       
    



    /*
    --------------------
    Add SoundPath Button
    --------------------
    */
    panel->addSoundPathButton = WMCreateCommandButton(panel->win);
    WMResizeWidget(panel->addSoundPathButton, 75,24);
    WMMoveWidget(panel->addSoundPathButton, 8, 144);
    WMSetButtonText(panel->addSoundPathButton, "Add");
    WMSetButtonAction(panel->addSoundPathButton, (WMAction *)addSoundPath, panel);
    /*
    -----------------------
    Remove SoundPath Button
    -----------------------
    */
    panel->removeSoundPathButton = WMCreateCommandButton(panel->win);
    WMResizeWidget(panel->removeSoundPathButton, 75,24);
    WMMoveWidget(panel->removeSoundPathButton, 91, 144);
    WMSetButtonText(panel->removeSoundPathButton, "Remove");
    WMSetButtonAction(panel->removeSoundPathButton, (WMAction *)removeSoundPath, panel);
    /*
    -------------
    Cancel Button
    -------------
    */
    panel->cancelButton = WMCreateCommandButton(panel->win);
    WMResizeWidget(panel->cancelButton, 75,24);
    WMMoveWidget(panel->cancelButton, 174, 144);
    WMSetButtonText(panel->cancelButton, "Cancel");
    WMSetButtonAction(panel->cancelButton, (WMAction *)wmssSoundPathButtonClick, panel);
    /*
    ---------
    OK Button
    ---------
    */
    panel->okButton = WMCreateCommandButton(panel->win);
    WMResizeWidget(panel->okButton, 75,24);
    WMMoveWidget(panel->okButton, 257, 144);
    WMSetButtonText(panel->okButton, "Okay");
    WMSetButtonAction(panel->okButton, (WMAction *)wmssSoundPathButtonClick, panel);

    WMRealizeWidget(panel->win);
    WMMapSubwidgets(panel->win);




    return panel;
}


int
wmssRunSoundPathPanel(WMSSSoundPathPanel *panel)
{
    XEvent event;

    WMMapWidget(panel->win);

    panel->flags.done = 0;

    while (!panel->flags.done) {
        WMNextEvent(dpy, &event);
        WMHandleEvent(&event);
    }

    WMUnmapWidget(panel->win);

    return (panel->flags.canceled ? False : True);
}


void
wmssDestroySoundPathPanel(WMSSSoundPathPanel *panel)
{
    WMUnmapWidget(panel->win);
    WMDestroyWidget(panel->win);
    free(panel);
}

