#ifndef CONFIG_H
#define CONFIG_H
/*
 * $Id: config.h,v 1.20 1997/11/28 04:46:29 dirk Exp $
 *
 * This file is part of WorkMan, the civilized CD player program
 * (c) 1991-1997 by Steven Grimm (original author)
 * (c) by Dirk F"orsterling (current 'author' = maintainer)
 * The maintainer can be contacted by his e-mail address:
 * milliByte@DeathsDoor.com 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
 * This file consists of several parts. First, there's a generic,
 * platform independent part. Set needed options there.
 * The following parts are platform dependent. You may search for the
 * names listed below and then set your OS specific options there.
 * Don't be surprised, if there are no options for your OS. They aren't
 * needed in any case.
 * 
 * The default values should produce a functional WorkMan on every
 * platform.
 *
 *********************
 * Current platforms:
 *********************
 * BSD386
 * FreeBSD
 * HP-UX
 * Irix (SGI)
 * Linux
 * News  (Sony NewsOS)
 * OpenBSD
 * OSF1
 * Sun (SunOS/Solaris)
 * SVR4
 * Ultrix
 */

/******************************************************************
 * generic options
 ******************************************************************/

/*
 * This option is obvious. But please do not forget the original
 * WorkMan version string if you need support.
 */
#define WORKMAN_VERSION_STRING "WorkMan 1.3b-BETA-1"
 
/*
 * If your CD-ROM drive closes its tray if the device is opened, then
 * the next define can make WorkMans "Eject" button an "open/close"
 * button. If it disturbs you, just comment it out.
 *
 * ### this is preliminary. It may have no effect for you ###
 */
#define CAN_CLOSE 1

/*
 * Define the following if you want the balance slider to
 * decrease one channel's volume while increasing the other's
 */
/* #define SYMETRIC_BALANCE 1 */

/******************************************************************
 * BSD386
 ******************************************************************
 ***     *****    ***    *******  **    ****    ****    ***********
 ***  **   **  ******  *  *****  ******  **  **  **  **************
 ***     ******  ****  **  ***  *****  *****    ***     ***********
 ***  **   ******  **  *  ***  ********  **  **  **  **  **********
 ***     *****    ***    ***  ******    ****    ****    ***********
 ******************************************************************/
#ifdef __bsdi__

/*
 * This lets you use the SoundBlaster Mixer on BSD/386
 */
#define SOUNDBLASTER 1

#endif /* __bsdi__ (BSD/386) */

/******************************************************************
 * FreeBSD
 ******************************************************************
 ***      **     ***      **      **     ****    ***    ***********
 ***  ******  **  **  ******  ******  **  **  ******  *  **********
 ***    ****     ***    ****    ****    ******  ****  **  *********
 ***  ******  **  **  ******  ******  **  ******  **  *  **********
 ***  ******  **  **      **      **     ****    ***    ***********
 ******************************************************************/
#if defined(__FreeBSD__) || defined(__NetBSD__)

#define DEFAULT_CD_DEVICE	"/dev/rmatcd0c"

#endif /* freebsd */

/******************************************************************
 * HP-UX
 ******************************************************************
 ***  **  **     *********  **  **  **  ***************************
 ***  **  **  **  ********  **  ***    ****************************
 ***      **     ***    **  **  ****  *****************************
 ***  **  **  ************  **  ***    ****************************
 ***  **  **  *************    ***  **  ***************************
 ******************************************************************/
#if defined(hpux) || defined (__hpux)

#define	DEFAULT_CD_DEVICE	"/dev/rscsi"

#endif /* hpux */

/******************************************************************
 * Irix
 ******************************************************************
 ***      **     ***      **  **  *********************************
 *****  ****  **  ****  *****    **********************************
 *****  ****     *****  ******  ***********************************
 *****  ****  **  ****  *****    **********************************
 ***      **  **  **      **  **  *********************************
 ******************************************************************/
#if defined(sgi)

#define DEFAULT_CD_DEVICE	"/dev/scsi/sc0d6l0"

#endif

/******************************************************************
 * Linux
 ******************************************************************
 ***  ******      **   ***  **  **  **  **  ***********************
 ***  ********  ****    **  **  **  ***    ************************
 ***  ********  ****  *  *  **  **  ****  *************************
 ***  ********  ****  **    **  **  ***    ************************
 ***      **      **  ***   ***    ***  **  ***********************
 ******************************************************************/
#ifdef linux

/*
 * Uncomment the following line to have WorkMan send SCSI commands
 *  directly to the CD-ROM drive.  If you have a SCSI drive you 
 * probably want this, but it will cause WorkMan to not work on IDE
 * drives.
 */
#define LINUX_SCSI_PASSTHROUGH 1

#define DEFAULT_CD_DEVICE	"/dev/sbpcd"

/*
 * Uncomment the following if you use the sbpcd or mcdx device driver.
 * It shouldn't hurt if you use it on other devices. It'll be nice to
 * hear from non-sbpcd (or mcdx) users if this is right.
 */
#define SBPCD_HACK 1

/*
 * Linux Soundcard support
 */
#define OSS_SUPPORT 1

/*
 * Uncomment the following if you want to try out a better responding
 * WorkMan, especially with IDE drives. This may work with non-IDE
 * drives as well. But it may be possible, that it doesn't work at all.
 * If your drive/driver combination cannot handle the faster access,
 * the driver will usually hang and you have to reboot your machine.
 */
/* #define FAST_IDE 1 */
 
/**-----------------------------------------------------
 **                non-user serviceable
 **/

/* Linux doesn't have a SIGEMT */
#ifndef SIGEMT
#define SIGEMT SIGUNUSED
#endif

#endif /* linux */

/******************************************************************
 * Sony NewsOS
 ******************************************************************
 ***   ***  **      **  *****  ***    *****************************
 ***    **  **  ******  *****  **  ********************************
 ***  *  *  **    ****  ** **  ****  ******************************
 ***  **    **  ******  *   *  ******  ****************************
 ***  ***   **      **    *    ***    *****************************
 ******************************************************************/
#if defined(__sony_news) || defined(sony_news)

#define	DEFAULT_CD_DEVICE	"/dev/rsd/b0i6u0p2\0"

#endif

/******************************************************************
 * OpenBSD
 ******************************************************************
 ****    ***     ***      **   ***  **     ****    ***    *********
 ***  **  **  **  **  ******    **  **  **  **  ******  *  ********
 ***  **  **     ***    ****  *  *  **    ******  ****  **  *******
 ***  **  **  ******  ******  **    **  **  ******  **  *  ********
 ****    ***  ******      **  ***   **     ****    ***    *********
 ******************************************************************/
#ifdef __OpenBSD__

#define	DEFAULT_CD_DEVICE	"/dev/rcdrom"

#endif

/******************************************************************
 * OSF1
 ******************************************************************
 ****    ****    ***      ***  ***  ***********************************
 ***  **  **  ******  ******  **    ***********************************
 ***  **  ****  ****    ***  *****  ***********************************
 ***  **  ******  **  ****  ******  ***********************************
 ****    ****    ***  ***  *****      *********************************
 ******************************************************************/
#if defined(__osf__)

#define	DEFAULT_CD_DEVICE	"/dev/rcdrom/cd0"

#endif

/******************************************************************
 * SunOS/Solaris
 ******************************************************************
 ****    ***  **  **   ***  ***************************************
 ***  ******  **  **    **  ***************************************
 *****  ****  **  **  *  *  ***************************************
 *******  **  **  **  **    ***************************************
 ****    ****    ***  ***   ***************************************
 ******************************************************************/
#if defined(sun) || defined(__sun__)

/*
 * Define the following for Solaris 2.x
 * If you don't want WorkMan to try to activate the SPARCstation 5
 * internal audio input so you get sound from the workstation, comment
 * out the CODEC define.
 */
#define SYSV 1
#define CODEC 1
/*
 * set the following to "SUNW,CS4231" for Sun and to "SUNW,sb16"
 * for PC (with SoundBlaster 16) running Solaris x86
 * (only important if you define CODEC above)
 */
#define SUN_AUD_DEV "SUNW,CS4231"


#endif

/******************************************************************
 * SVR4
 ******************************************************************
 ****    ***  ****  **     ***  *  ********************************
 ***  ******  ****  **  **  **  *  ********************************
 *****  *****  **  ***     ***      *******************************
 *******  ***  **  ***  **  *****  ********************************
 ****    *****    ****  **  *****  ********************************
 ******************************************************************/
#if defined(SVR4) && !defined(sun) && !defined(__sun__)

#define DEFAULT_CD_DEVICE       "/dev/rcdrom/cd0"

#endif

/******************************************************************
 * Ultrix
 ******************************************************************
 ***  **  **  *****      **     ***      **  **  ******************
 ***  **  **  *******  ****  **  ****  *****    *******************
 ***  **  **  *******  ****     *****  ******  ********************
 ***  **  **  *******  ****  **  ****  *****    *******************
 ****    ***      ***  ****  **  **      **  **  ******************
 ******************************************************************/
#if defined(ultrix) || defined(__ultrix)

#endif

/******************************************************************/ 
#endif /* CONFIG_H */
