;; $Id: dbl10n.dsl 1.7 1998/07/31 12:38:21 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x and #x
;; keywords.
;;

(define %default-language% "usen")
(define %gentext-language% #f)
(define %gentext-use-xref-lang% #f)

(define ($lang$ #!optional (target (current-node)) (xref-context #f))
  (if %gentext-language%
      (case-fold-down %gentext-language%)
      (if (or xref-context %gentext-use-xref-lang%)
	  (let loop ((here target))
	    (if (node-list-empty? here)
		(case-fold-down %default-language%)
		(if (attribute-string "LANG" here)
		    (case-fold-down (attribute-string "LANG" here))
		    (loop (parent here)))))
	  (if (inherited-attribute-string "LANG")
	      (case-fold-down (inherited-attribute-string "LANG"))
	      (case-fold-down %default-language%)))))

(define (gentext-xref-strings target)
  (let ((giname (case-fold-up (if (string? target) target (gi target))))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-usen[ (("usen") (gentext-usen-xref-strings giname)) ]]>
      <![%l10n-dege[ (("dege") (gentext-dege-xref-strings giname)) ]]>
      <![%l10n-bmno[ (("bmno") (gentext-bmno-xref-strings giname)) ]]>
      <![%l10n-ru[   (("ru")   (gentext-ru-xref-strings giname)) ]]>
      <![%l10n-fr[   (("fr")   (gentext-fr-xref-strings giname)) ]]>
      (else (error "L10N ERROR: gentext-xref-strings")))))

(define (gentext-xref-strings-indirect key)
  (case ($lang$)
    <![%l10n-usen[ (("usen") (gentext-usen-xref-strings-indirect key)) ]]>
    <![%l10n-dege[ (("dege") (gentext-dege-xref-strings-indirect key)) ]]>
    <![%l10n-bmno[ (("bmno") (gentext-bmno-xref-strings-indirect key)) ]]>
    <![%l10n-ru[   (("ru")   (gentext-ru-xref-strings-indirect key)) ]]>
    <![%l10n-fr[   (("fr")   (gentext-fr-xref-strings-indirect key)) ]]>
    (else (error "L10N ERROR: gentext-xref-strings-indirect"))))

(define (generate-toc-in-front)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %generate-usen-toc-in-front%) ]]>
    <![%l10n-dege[ (("dege") %generate-dege-toc-in-front%) ]]>
    <![%l10n-bmno[ (("bmno") %generate-bmno-toc-in-front%) ]]>
    <![%l10n-ru[   (("ru")   %generate-ru-toc-in-front%) ]]>
    <![%l10n-fr[   (("fr")   %generate-fr-toc-in-front%) ]]>
    (else (error "L10N ERROR: generate-toc-in-front"))))

(define (gentext-element-name target)
  (let ((giname (case-fold-up (if (string? target) target (gi target))))
	(lang   (if (string? target) ($lang$) ($lang$ target #t))))
    (case lang
      <![%l10n-usen[ (("usen") (gentext-usen-element-name giname)) ]]>
      <![%l10n-dege[ (("dege") (gentext-dege-element-name giname)) ]]>
      <![%l10n-bmno[ (("bmno") (gentext-bmno-element-name giname)) ]]>
      <![%l10n-ru[ (("ru")     (gentext-ru-element-name giname)) ]]>
      <![%l10n-fr[ (("fr")     (gentext-fr-element-name giname)) ]]>
      (else (error "L10N ERROR: gentext-element-name")))))

(define (gentext-element-name-space target)
  (let ((giname (case-fold-up (if (string? target) target (gi target))))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-usen[ (("usen") (gentext-usen-element-name-space giname)) ]]>
      <![%l10n-dege[ (("dege") (gentext-dege-element-name-space giname)) ]]>
      <![%l10n-bmno[ (("bmno") (gentext-bmno-element-name-space giname)) ]]>
      <![%l10n-ru[ (("ru")     (gentext-ru-element-name-space giname)) ]]>
      <![%l10n-fr[ (("fr")     (gentext-fr-element-name-space giname)) ]]>
      (else (error "L10N ERROR: gentext-element-name-space")))))

(define (gentext-intra-label-sep target)
  (let ((giname (case-fold-up (if (string? target) target (gi target))))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-usen[ (("usen") (gentext-usen-intra-label-sep giname)) ]]>
      <![%l10n-dege[ (("dege") (gentext-dege-intra-label-sep giname)) ]]>
      <![%l10n-bmno[ (("bmno") (gentext-bmno-intra-label-sep giname)) ]]>
      <![%l10n-ru[ (("ru")     (gentext-ru-intra-label-sep giname)) ]]>
      <![%l10n-fr[ (("fr")     (gentext-fr-intra-label-sep giname)) ]]>
      (else (error "L10N ERROR: gentext-intra-label-sep")))))

(define (gentext-label-title-sep target)
  (let ((giname (case-fold-up (if (string? target) target (gi target))))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-usen[ (("usen") (gentext-usen-label-title-sep giname)) ]]>
      <![%l10n-dege[ (("dege") (gentext-dege-label-title-sep giname)) ]]>
      <![%l10n-bmno[ (("bmno") (gentext-bmno-label-title-sep giname)) ]]>
      <![%l10n-ru[ (("ru")     (gentext-ru-label-title-sep giname)) ]]>
      <![%l10n-fr[ (("fr")     (gentext-fr-label-title-sep giname)) ]]>
      (else (error "L10N ERROR: gentext-label-title-sep")))))

(define ($lot-title$ lotgi)
  (case ($lang$)
    <![%l10n-usen[ (("usen") ($lot-title-usen$ lotgi)) ]]>
    <![%l10n-dege[ (("dege") ($lot-title-dege$ lotgi)) ]]>
    <![%l10n-bmno[ (("bmno") ($lot-title-bmno$ lotgi)) ]]>
    <![%l10n-ru[ (("ru")     ($lot-title-ru$ lotgi)) ]]>
    <![%l10n-fr[ (("fr")     ($lot-title-fr$ lotgi)) ]]>
    (else (error "L10N ERROR: $lot-title$"))))

(define (gentext-start-quote)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-start-quote%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-start-quote%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-start-quote%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-start-quote%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-start-quote%) ]]>
    (else (error "L10N ERROR: gentext-start-quote"))))

(define (gentext-end-quote)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-end-quote%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-end-quote%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-end-quote%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-end-quote%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-end-quote%) ]]>
    (else (error "L10N ERROR: gentext-end-quote"))))

(define (gentext-by)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-by%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-by%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-by%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-by%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-by%) ]]>
    (else (error "L10N ERROR: gentext-by"))))

(define (gentext-edited-by)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-edited-by%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-edited-by%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-edited-by%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-edited-by%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-edited-by%) ]]>
    (else (error "L10N ERROR: gentext-edited-by"))))

(define (gentext-page)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-page%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-page%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-page%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-page%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-page%) ]]>
    (else (error "L10N ERROR: gentext-page"))))

(define (gentext-and)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-and%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-and%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-and%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-and%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-and%) ]]>
    (else (error "L10N ERROR: gentext-and"))))

(define (gentext-bibl-pages)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-bibl-pages%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-bibl-pages%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-bibl-pages%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-bibl-pages%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-bibl-pages%) ]]>
    (else (error "L10N ERROR: gentext-bibl-pages"))))

(define (gentext-endnotes)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-endnotes%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-endnotes%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-endnotes%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-endnotes%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-endnotes%) ]]>
    (else (error "L10N ERROR: gentext-endnotes"))))

(define (gentext-table-endnotes)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-table-endnotes%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-table-endnotes%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-table-endnotes%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-table-endnotes%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-table-endnotes%) ]]>
    (else (error "L10N ERROR: gentext-table-endnotes"))))

(define (gentext-index-see)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-index-see%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-index-see%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-index-see%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-index-see%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-index-see%) ]]>
    (else (error "L10N ERROR: gentext-index-see"))))

(define (gentext-index-seealso)
  (case ($lang$)
    <![%l10n-usen[ (("usen") %gentext-usen-index-seealso%) ]]>
    <![%l10n-dege[ (("dege") %gentext-dege-index-seealso%) ]]>
    <![%l10n-bmno[ (("bmno") %gentext-bmno-index-seealso%) ]]>
    <![%l10n-ru[ (("ru")     %gentext-ru-index-seealso%) ]]>
    <![%l10n-fr[ (("fr")     %gentext-fr-index-seealso%) ]]>
    (else (error "L10N ERROR: gentext-index-seealso"))))

