;; $Id: dbindex.dsl 1.2 1998/06/12 12:07:39 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ................... INDEX TERMS (EMBEDDED MARKERS) ...................

(element indexterm (empty-sosofo))
(element primary (empty-sosofo))
(element secondary (empty-sosofo))
(element tertiary (empty-sosofo))
(element see (empty-sosofo))
(element seealso (empty-sosofo))

;; =========================== INDEX ELEMENTS ===========================

(element setindex ($component$))
(element (setindex title) (empty-sosofo))

(element index ($component$))
(element (index title) (empty-sosofo))

(element indexdiv ($section$))
(element (indexdiv title) (empty-sosofo))

(element indexentry
  (let* ((primary   (select-elements (children (current-node)) 
				     (normalize "primaryie")))
	 (secondary (select-elements (children (current-node)) 
				     (normalize "secondaryie")))
	 (tertiary  (select-elements (children (current-node)) 
				     (normalize "tertiaryie")))
	 (see       (select-elements (children (current-node)) 
				     (normalize "seeie")))
	 (seealso   (select-elements (children (current-node)) 
				     (normalize "seealsoie"))))
    ;; this is a bit of a hack because each indexentry is its own DL
    (make element gi: "DL"
	  (make element gi: "DT"
		(process-node-list primary))
	  (if (node-list-empty? secondary)
	      (empty-sosofo)
	      (make element gi: "DD"
		    (make element gi: "DL"
			  (make element gi: "DT"
				(process-node-list secondary))
			  (if (node-list-empty? tertiary)
			      (empty-sosofo)
			      (make element gi: "DD"
				    (make element gi: "DL"
					  (make element gi: "DT"
						(process-node-list tertiary))))))))
	  (if (node-list-empty? see)
	      (empty-sosofo)
	      (make element gi: "DD"
		    (make element gi: "DL"
			  (make element gi: "DT"
				(make sequence
				  (literal "(" (gentext-index-see) " ")
				  (process-node-list see)
				  (literal ")"))))))

	  (if (node-list-empty? seealso)
	      (empty-sosofo)
	      (make element gi: "DD"
		    (make element gi: "DL"
			  (make element gi: "DT"
				(make sequence
				  (literal "(" (gentext-index-seealso) " ")
				  (process-node-list seealso)
				  (literal ")")))))))))

(element primaryie (process-children))
(element secondaryie (process-children))
(element tertiaryie (process-children))
(element seeie (process-children))
(element seealsoie (process-children))
